#ifndef UpperTesterSremSsemCODEC_H
#define UpperTesterSremSsemCODEC_H

#include <memory>

#include "codec.hh"
#include "params.hh"

class Base_Type;
class Record_Type;
class TTCN_Typedescriptor_t;
class TTCN_Buffer;

namespace LibItsSremSsem__TypesAndValues {
  class UtSremResults;
  class UtSremEventInd;
  class UtSsemEventInd;
}

class UpperTesterSremSsemCodec: public codec <
  Record_Type,
  Record_Type>
{
  const unsigned char c_utSremSsemInitialize = 0x00;
  const unsigned char c_utSremSsemInitializeResult = 0x01;
  const unsigned char c_utSremSsemTrigger = 0xAB;
  const unsigned char c_utSremSsemTriggerResult = 0xAC;
  const unsigned char c_utSremSsemUpdate = 0xAD;
  const unsigned char c_utSremSsemUpdateResult = 0xAE;
  const unsigned char c_utSremEventInd = 0xAF;
  const unsigned char c_utSsemEventInd = 0xB0;

  int encode_ (const Base_Type& type, const TTCN_Typedescriptor_t& field_descriptor, TTCN_Buffer& encoding_buffer);

public:
  UpperTesterSremSsemCodec() : codec<Record_Type, Record_Type>() { };
  virtual ~UpperTesterSremSsemCodec() { };

  virtual int encode (const Record_Type&, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, Record_Type&, params* params = NULL);
  std::unique_ptr<Base_Type> decode (const OCTETSTRING& data, params* params = NULL);
  
private:
  int decode (const OCTETSTRING& data, LibItsSremSsem__TypesAndValues::UtSremResults& msg, params* params = NULL);
  int decode (const OCTETSTRING& data, LibItsSremSsem__TypesAndValues::UtSremEventInd& msg, params* params = NULL);
  int decode (const OCTETSTRING& data, LibItsSremSsem__TypesAndValues::UtSsemEventInd& msg, params* params = NULL);
};
#endif
