/*!
 * \file      ivim_layer.hh
 * \brief     Header file for ITS IVIM protocol layer.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "t_layer.hh"
#include "ivim_codec.hh"

namespace LibItsIvim__TestSystem {
  class IvimPort;
  class IvimReq;
  class IvimInd;
}

class ivim_layer : public t_layer<LibItsIvim__TestSystem::IvimPort> {
  params _params;
  ivim_codec _codec;
public:
  ivim_layer() : t_layer<LibItsIvim__TestSystem::IvimPort>(), _params(), _codec() {};
  ivim_layer(const std::string& p_type, const std::string& param);
  virtual ~ivim_layer() {};

  void sendMsg(const LibItsIvim__TestSystem::IvimReq&, params& params);
    
  virtual void send_data(OCTETSTRING& data, params& params);
  virtual void receive_data(OCTETSTRING& data, params& info);
}; // End of class ivim_layer

