#!/bin/bash
# Prepare environment for the build
#set -e # Exit with non 0 if any command fails
#set -vx

# Update system
sudo DEBIAN_FRONTEND=noninteractive apt-get update
sudo DEBIAN_FRONTEND=noninteractive apt-get dist-upgrade -y
sudo DEBIAN_FRONTEND=noninteractive apt-get install software-properties-common -y
sudo DEBIAN_FRONTEND=noninteractive add-apt-repository ppa:linuxuprising/java -y
sudo DEBIAN_FRONTEND=noninteractive apt-get update
sudo DEBIAN_FRONTEND=noninteractive apt-get --allow-unauthenticated install emacs openjdk-11-jre gcc-8 g++-8 git subversion lsof ntp gdb make cmake flex bison autoconf doxygen graphviz libtool libncurses5-dev expect libssl-dev libxml2-dev xutils-dev tcpdump libpcap-dev libwireshark-dev wget tree unzip sshpass kubuntu-desktop valgrind qt5-default qtmultimedia5-dev libqt5svg5-dev -y
#sudo DEBIAN_FRONTEND=noninteractive apt-get --allow-unauthenticated install oracle-java10-installer oracle-java10-set-default -y
#sudo DEBIAN_FRONTEND=noninteractive apt --fix-broken install -y
sudo DEBIAN_FRONTEND=noninteractive apt-get autoremove --purge -y
sudo DEBIAN_FRONTEND=noninteractive apt-get clean

gcc --version
g++ --version
valgrind --version
java -version

export USERNAME=$1
export PASSWORD=$2

export HOME=/home/vagrant

export PATH_DEV=${HOME}/dev
export HOME_FRAMEWORKS=${HOME}/frameworks
export HOME_LIB=${HOME}/lib
export HOME_BIN=${HOME}/bin
export HOME_ETC=${HOME}/etc
export HOME_INC=${HOME}/include
export HOME_TMP=${HOME}/tmp
export HOME_DOCS=${HOME}/docs
export PATH=${HOME_BIN}:${PATH}
export LD_LIBRARY_PATH=${HOME_LIB}:/usr/local/lib:${LD_LIBRARY_PATH}

OLD_PWD=`pwd`
# Create directories
mkdir -p ${HOME_LIB}
if [ ! -d ${HOME_LIB} ]
then
    exit -1
fi
mkdir -p ${HOME_INC}
if [ ! -d ${HOME_INC} ]
then
    exit -1
fi
mkdir -p ${HOME_BIN}
if [ ! -d ${HOME_BIN} ]
then
    exit -1
fi
mkdir -p ${HOME_TMP}
if [ ! -d ${HOME_TMP} ]
then
    exit -1
fi
mkdir -p ${HOME_DOCS}
if [ ! -d ${HOME_DOCS} ]
then
    exit -1
fi
mkdir -p ${HOME_FRAMEWORKS}
if [ ! -d ${HOME_FRAMEWORKS} ]
then
    exit -1
fi
mkdir -p ${PATH_DEV}
if [ ! -d ${PATH_DEV} ]
then
    exit -1
fi

cd /home/vagrant/dev 
svn co --username $USERNAME --password $PASSWORD --non-interactive https://oldforge.vagrant.org/svn/ITS/branches/STF525 ./STF525_Its 
cd /home/vagrant/dev/STF525_Its/scripts
chmod 775 *.bash devenv.bash.*
cd /home/vagrant/dev/STF525_Its/docker
chmod 775 *.sh
cd /home/vagrant/dev/STF525_Its
chmod 775 ./.jenkins.sh
cd /home/vagrant
ln -sf /home/vagrant/dev/STF525_Its/scripts/devenv.bash.ubuntu /home/vagrant/devenv.bash
. /home/vagrant/devenv.bash

# Install all frameworks
cd ${HOME_FRAMEWORKS}

# Install asn1c
cd ${HOME_FRAMEWORKS}
git clone https://github.com/vlm/asn1c.git asn1c
cd ${HOME_FRAMEWORKS}/asn1c
test -f configure || autoreconf -iv
./configure
make && sudo make install
cd -

# Install GoogleTest
cd ${HOME_FRAMEWORKS}
git clone https://github.com/google/googletest.git googletest
cd ${HOME_FRAMEWORKS}/googletest/
cmake .
make CXX=g++
sudo make install
cd -

# Install latest LCOV
mkdir -p ${HOME_FRAMEWORKS}/lcov
cd ${HOME_FRAMEWORKS}/lcov
wget http://ftp.de.debian.org/debian/pool/main/l/lcov/lcov_1.13.orig.tar.gz
tar xf lcov_1.13.orig.tar.gz
sudo make -C lcov-1.13/ install
cd -

# Install lcov to coveralls conversion
sudo gem install coveralls-lcov

lcov --version
coveralls-lcov -h

# Install java
sudo DEBIAN_FRONTEND=noninteractive apt-get install oracle-java9-installer oracle-java9-set-default -y
java --version

# Install eclipse
cd ${HOME_FRAMEWORKS}

wget 'http://ftp.halifax.rwth-aachen.de/eclipse/technology/epp/downloads/release/oxygen/2/eclipse-cpp-oxygen-2-linux-gtk-x86_64.tar.gz' -Oeclipse-cpp-oxygen-2-linux-gtk-x86_64.tar.gz
tar -zxvf ./eclipse-cpp-oxygen-2-linux-gtk-x86_64.tar.gz
rm -f ./eclipse-cpp-oxygen-2-linux-gtk-x86_64.tar.gz

# Checkout the project
if [ ${USERNAME} != '' ] && [ ${PASSWORD} != '' ]
then
    cd ${HOME}/tmp
    svn co --username $USERNAME --password $PASSWORD --non-interactive https://oldforge.vagrant.org/svn/ITS/branches/STF525
fi

echo "" >> /etc/profile 
echo "export HOME=/home/etsi" >> /etc/profile 
echo "export LD_LIBRARY_PATH=/home/etsi/TriesAndDelete/etsi_its/lib:$LD_LIBRARY_PATH" >> /etc/profile 
echo "export PATH=/home/etsi/bin:$PATH" >> /etc/profile 
echo "cd /home/etsi" >> /etc/profile 
echo ". ./devenv.bash" >> /etc/profile 

cd /home/vagrant/dev/STF525_Its/scripts
./build_titan.bash 
. /home/etsi/devenv.bash 
./update_its_project.bash
#ln -sf ~/TriesAndDelete/etsi_its/lib/libItsAsn.so ~/lib/libItsAsn.so
#cd ${HOME}/TriesAndDelete/etsi_its/src/TestCodec/objs
#. ${HOME}/devenv.bash
#../bin/testcodec_generate_makefile.bash
#../bin/run_mtc.bash &
#../bin/run_ptcs.bash

cd ${OLD_PWD}

unset USERNAME
unset PASSWORD

sudo init 6

exit 0
