# ETSI ITS protocols project


## General Information

This repositories contains the test specifications and test adapter code for ETSI ITS protocols testing.
ETSI ITS protocols project supports:
- ETSI EN 302 637-2: "Intelligent Transport Systems (ITS); Vehicular Communications; Basic Set of Applications; Part 2: Specification of Cooperative Awareness Basic Service"
- ETSI EN 102 637-3: "Intelligent Transport Systems (ITS); Vehicular Communications; Basic Set of Applications; Part 3: Specifications of Decentralized Environmental Notification Basic Service" 
- ETSI TS 103 301: "Intelligent Transport Systems (ITS); Vehicular Communications; Basic Set of Applications; Facilities layer protocols and communication requirements for infrastructure services"
- EN 302 636-5-1: "Intelligent Transport Systems (ITS); Vehicular Communications; GeoNetworking; Part 5: Transport Protocols; Sub-part 1: Basic Transport Protocol"
- EN 302 636-4-1: "Intelligent Transport Systems (ITS); Vehicular Communications; GeoNetworking; Part 4: Geographical addressing and forwarding for point-to-point and point-to-multipoint communications; Sub-part 1: Media-Independent Functionality"

In addition, it also support ITS Security as define by:
- ETSI TS 103 940: "Intelligent Transport Systems (ITS); Security; Security Architecture and Management".
- ETSI TS 102 941: "Intelligent Transport Systems (ITS); Security; Trust and Privacy Management technical specification"
- IEEE Std 1609.2™-2016: "IEEE Standard for Wireless Access in Vehicular Environments –Security Services for Applications and Management Messages"
- IEEE Std 1609.2a™-2017: "Standard for Wireless Access In Vehicular Environments – Security Services for Applications and Management Messages Amendment 1".

Contact information
Email at cti_support at etsi dot org

License
Unless specified otherwise, the content of this repository and the files contained are released under the ETSI Software License.
See the attached LICENSE file or visit
https://forge.etsi.org/etsi-software-license

## STFs

The following STFs were or are currently involved in the evolutions of the ETSI ITS protocols project:
- STF 405, STF 422, STF 424, STF 455, STF 462, STF 481, STF 484, STF 507, STF 517, STF 525, STF 538, STF 545


## Installation

The ETSI ITS protocols project builds and tests regularly on the following platforms:

  - Linux (Ubuntu)

### Using Vagrant

Pre-requisites on your host machine:
- Install [Virtualbox](https://www.virtualbox.org/manual/ch01.html)
- Install [Vagrant](https://www.vagrantup.com/intro/getting-started/)
- Credentials to access [ETSI forge](https://oldforge.etsi.org/!/#)
    - Set the environment variable USERNAME to your ETSI OEL account user name
    - Set the environment variable PASSWORD to your ETSI OEL account password

Procedure:
- On your host machine, open a command line session (PuTTY, DOS window...)
- From the ETSI ITS protocols project, clone the Vagrant folder
- In the file Vagrantfilem, odify the tag config.vm.provision replacing <username> & <password> strings by your ETSI credentials
- In the Vagrant folder, execute the following commands:

```sh
$ vagrant up --provider virtualbox --provision
...
```

NOTE The creation and the installations will take some time to achieve
- Stop vagrant virtual machine

```sh
$ vagrant halt
...
```

- Update the file 'Vagrantfile' to match with your networks configuration
- Re-start the vagrant virtual machine and log to to the machine

```sh
$ vagrant up
...
$ vagrant ssh
```

- Switch to the next clause (Usage)


### Using Docbox

Pre-requisites on your host machine:
- Install Virtualbox
- Install Docbox

Procedure for a Windows host machine:
- On your host machine, open a the Docker Quickstart Terminal
- On your host machine, clone the ETSI ITS protocols project. NOTE that only Docbox folder and .jenkins.sh script file are required
- From the ETSI ITS protocols project root directory, execute the following commands:

```sh
$ ./.jenkins.sh
...
```

NOTE The creation and the installations will take some time to achieve
- Start the container

```sh
$ ./docker/run-container.sh
# su - etsi
```

- Switch to the next clause (Usage)


### From scratch

Pre-requisites:
- Install Virtualbox

Procedure:
- Install a new Linux Virtual machine (Mint, Debian...)
- Update your system with the latest version of kernel and security packages
- Install the following packages (According to the Linux chosen, the package naming can be different)
    autoconf
    bison
    build-essential
    cmake
    curl
    doxygen
    emacs
    expect
    flex
    graphviz
    gdb 
    git-core
    gnutls-bin
    libglib2.0-dev
    libpcap-dev
    libgcrypt-dev
    libncurses5-dev
    libssl-dev
    libtool-bin
    libtool
    libwireshark-dev
    libxml2-dev
    lsof
    ntp
    pkg-config
    qt5-default
    qtmultimedia5-dev
    libqt5svg5-dev
    subversion
    sudo
    sshpass
    tcpdump
    texlive-font-utils
    tshark
    valgrind
    vsftpd
    xutils-dev 
    tree
    unzip
    wget
- In your home directory, create the following folders: 
    - $HOME/frameworks, 
    - $HOME/dev
    - $HOME/lib
- In $HOME/frameworks, build the following package:
    - asn1c, according the procedure specified [here](https://github.com/vlm/asn1c.git)
    - Eclipse IDE for C/C++ Developers, according the procedure specified [here](https://www.eclipse.org/cdt/)
    - TITAN, according the procedure specified [here](https://github.com/eclipse/titan.core)
    - Import the TITAN plugin into your Eclipse IDE, according the procedure specified [here](https://github.com/eclipse/titan.core)
- Clone the ETSI ITS protocols project into $HOME/dev folder
- ...
- Switch to the next clause (Usage)


## Usage

This clause describes how to compile and execute an Abstract Test Suite.
The procedures below illustrate how to run the CAM test suite. The same procedures will apply for any other ETSI ITS test suite.


Pre-requisites:
- Your machine is installed followimg one of the installation method describes in the previous clause
- Your are logged as 'etsi' user

Procedure using Eclipse TITAN:

Procedure in TITAN command line:
- Open several SSH session (PuTTY...)
- Change to the directory ~/dev/STF525_Its/src/AtsCAM/objs
- Edit the file ../etc/AtsCAM.cfg
- Update the following fields:
    - system.camPort.params
    - system.utPort.params
- Execute the following command:

```sh
$ ../bin/run-all.bash
# su - etsi
```

- The log files are located in ../logs folder. Yu can edit them using any editor or using the Eclipse TITAN log plugins
- Your machine is installed followimg one of the installation method describes in the previous clause


## Rebuild Wireshark with support of ETSI ITS Protocols

A specific version of Wireshark, based on official version 2.6.x, is available [here](https://github.com/YannGarcia/wireshark-for-ITS.git).

The following Pre-requisites applies to build it:
- Your machine is installed followimg one of the installation method describes in the previous clause
- Your are logged as 'etsi' user

The following procedure applies to build it:
- Open a SSH session (PuTTY...)
- Change to the directory ~/frameworks
- Execute the following comands to clone the project and switch to the branck

```sh
$ git clone https://github.com/YannGarcia/wireshark-for-ITS.git wireshark-for-ITS
$ git checkout ITS_Protocol_Support
```

- Create a folder ~/frameworks/wireshark-build
- Change to this folder
- Generate makefiles executing the following command

```sh
$ cmake ../wireshark-for-ITS
```

- Add specific compiler options the file epan/dissectors/CMakeFiles/dissectors.dir/flags.make:
    - Find the variable C_FLAGS
    - Append the following options: "-Wno-unused-const-variable -Wno-unsued-function "
- Build Wireshark/tshark executing the following command

```sh
$ make
```

- After the build, binaries are located in ~/frameworks/wireshark-build/run folder
- To distinguish this version of Wireshark from the others, a development tag 'ETSI ITS Protocols' is displayed on the GUI version

## How to Report a Bug

The ETSI ITS protocols project is under constant development, so it is possible that you will
encounter a bug while using it. Please report bugs at cti_support at etsi dot org.
