package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils;

import de.fraunhofer.sit.c2x.pki.ca.certificates.datacontainers.GeographicRegionDataContainer;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.CircularRegion;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.GeographicRegion;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.IdentifiedRegion;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.IntX;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.PolygonalRegion;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.RectangularRegion;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.RegionDictionaryImpl.RegionDictionary;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.RegionTypeImpl.RegionType;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.TwoDLocation;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.UInt16;

public class EtsiRegionUtils {

	public static GeographicRegion regionContainerToGeographicRegion(
			GeographicRegionDataContainer regionContainer) {
		GeographicRegion geographicRegion = new GeographicRegion();

		if (regionContainer == null) {
			geographicRegion.setRegionType(RegionType.NONE);
			return geographicRegion;
		}

		// Identified Region Restriction
		if (regionContainer.getDictionary() != null && !regionContainer.getDictionary().isEmpty()
				&& regionContainer.getRegionIdentifier() != null
				&& regionContainer.getRegionIdentifier() >= 0 && regionContainer.getLocalRegion() != null
				&& regionContainer.getLocalRegion() >= 0) {
			geographicRegion.setRegionType(RegionType.ID);
			IdentifiedRegion idRegion = new IdentifiedRegion();

			if (regionContainer.getDictionary().equals("iso_3166_1"))
				idRegion.setGlobalRegion(RegionDictionary.ISO_3166_1);
			else if (regionContainer.getDictionary().equals("un_stats"))
				idRegion.setGlobalRegion(RegionDictionary.UN_STATS);
			else {
				String dictsString = "";
				RegionDictionary[] dicts = RegionDictionary.values();
				for (RegionDictionary rd : dicts) {
					if (dictsString.isEmpty())
						dictsString += rd.toString();
					else
						dictsString += ", " + rd.toString();
				}
				throw new IllegalArgumentException("Given region dictionary string \""
						+ regionContainer.getDictionary() + "\" cannot be mapped with dictionaries: "
						+ dictsString);
			}

			idRegion.setRegionIdentifier(new UInt16(regionContainer.getRegionIdentifier().intValue()));
			idRegion.setLocalRegion(new IntX(regionContainer.getLocalRegion()));
			geographicRegion.setIdRegion(idRegion);
		}
		// Circular Region Restriction
		if (regionContainer.getCenterLatitude() != null && regionContainer.getCenterLongitude() != null
				&& regionContainer.getRadius() != null && regionContainer.getRadius() >= 0) {

			if (geographicRegion.getRegionType() != null)
				throw new IllegalArgumentException("Only one region restriction type allowed. Type "
						+ geographicRegion.getRegionType()
						+ " already set but values for cirular region restriction also set");

			geographicRegion.setRegionType(RegionType.CIRCLE);
			TwoDLocation twoDLocation = new TwoDLocation(regionContainer.getCenterLatitude(),
					regionContainer.getCenterLongitude());
			CircularRegion circularRegion = new CircularRegion(twoDLocation, new UInt16(
					regionContainer.getRadius()));
			geographicRegion.setCircularRegion(circularRegion);
		}
		// Rectangular Region Restriction
		if (regionContainer.getRectangleNorthWestLatitudes() != null
				&& regionContainer.getRectangleNorthWestLatitudes().length > 0
				&& regionContainer.getRectangleNorthWestLongitudes() != null
				&& regionContainer.getRectangleNorthWestLongitudes().length > 0
				&& regionContainer.getRectangleSouthEastLatitudes() != null
				&& regionContainer.getRectangleSouthEastLatitudes().length > 0
				&& regionContainer.getRectangleSouthEastLongitudes() != null
				&& regionContainer.getRectangleSouthEastLongitudes().length > 0) {

			if (geographicRegion.getRegionType() != null)
				throw new IllegalArgumentException("Only one region restriction type allowed. Type "
						+ geographicRegion.getRegionType()
						+ " already set but values for rectangular region restriction also set");

			geographicRegion.setRegionType(RegionType.RECTANGLE);

			int length = regionContainer.getRectangleNorthWestLatitudes().length;
			RectangularRegion[] rectangularRegion = new RectangularRegion[length];
			for (int i = 0; i < length; i++) {
				TwoDLocation northWest = new TwoDLocation(
						regionContainer.getRectangleNorthWestLatitudes()[i],
						regionContainer.getRectangleNorthWestLongitudes()[i]);
				TwoDLocation southEast = new TwoDLocation(
						regionContainer.getRectangleSouthEastLatitudes()[i],
						regionContainer.getRectangleSouthEastLongitudes()[i]);
				RectangularRegion rectangle = new RectangularRegion(northWest, southEast);
				rectangularRegion[i] = rectangle;
			}

			geographicRegion.setRectangularRegion(rectangularRegion);
		}
		// Polygonal Region Restriction
		if (regionContainer.getPolygonalPointLatitudes() != null
				&& regionContainer.getPolygonalPointLatitudes().length > 0
				&& regionContainer.getPolygonalPointLongitudes() != null
				&& regionContainer.getPolygonalPointLongitudes().length > 0) {

			if (geographicRegion.getRegionType() != null)
				throw new IllegalArgumentException("Only one region restriction type allowed. Type "
						+ geographicRegion.getRegionType()
						+ " already set but values for polygonal region restriction also set");

			geographicRegion.setRegionType(RegionType.POLYGON);

			int length = regionContainer.getPolygonalPointLatitudes().length;

			TwoDLocation[] polygonPoints = new TwoDLocation[length];
			for (int i = 0; i < length; i++) {
				TwoDLocation point = new TwoDLocation(regionContainer.getPolygonalPointLatitudes()[i],
						regionContainer.getPolygonalPointLongitudes()[i]);

				polygonPoints[i] = point;
			}

			PolygonalRegion polygon = new PolygonalRegion(polygonPoints);
			geographicRegion.setPolygonalRegion(polygon);
		}

		if (geographicRegion.getRegionType() == null)
			geographicRegion.setRegionType(RegionType.NONE);
		
		return geographicRegion;
	}
}
