/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.values;

import com.siemens.ct.exi.values.AbstractBinaryValue;
import com.siemens.ct.exi.values.ValueType;

public class BinaryHexValue
extends AbstractBinaryValue {
    private static final long serialVersionUID = 4914135099644891193L;
    private int lengthData;
    private static final int BASELENGTH = 128;
    private static final int LOOKUPLENGTH = 16;
    private static final byte[] hexNumberTable = new byte[128];
    private static final char[] lookUpHexAlphabet = new char[16];

    static {
        int i = 0;
        while (i < 128) {
            BinaryHexValue.hexNumberTable[i] = -1;
            ++i;
        }
        i = 57;
        while (i >= 48) {
            BinaryHexValue.hexNumberTable[i] = (byte)(i - 48);
            --i;
        }
        i = 70;
        while (i >= 65) {
            BinaryHexValue.hexNumberTable[i] = (byte)(i - 65 + 10);
            --i;
        }
        i = 102;
        while (i >= 97) {
            BinaryHexValue.hexNumberTable[i] = (byte)(i - 97 + 10);
            --i;
        }
        i = 0;
        while (i < 10) {
            BinaryHexValue.lookUpHexAlphabet[i] = (char)(48 + i);
            ++i;
        }
        i = 10;
        while (i <= 15) {
            BinaryHexValue.lookUpHexAlphabet[i] = (char)(65 + i - 10);
            ++i;
        }
    }

    public BinaryHexValue(byte[] bytes) {
        super(ValueType.BINARY_HEX, bytes);
    }

    public static BinaryHexValue parse(String val) {
        byte[] bytes = BinaryHexValue.decode(val);
        if (bytes == null) {
            return null;
        }
        return new BinaryHexValue(bytes);
    }

    public int getCharactersLength() {
        if (this.slen == -1) {
            this.lengthData = this.bytes.length;
            this.slen = this.lengthData * 2;
        }
        return this.slen;
    }

    public void getCharacters(char[] cbuffer, int offset) {
        this.getCharactersLength();
        int i = 0;
        while (i < this.lengthData) {
            int temp = this.bytes[i];
            if (temp < 0) {
                temp += 256;
            }
            cbuffer[offset + i * 2] = lookUpHexAlphabet[temp >> 4];
            cbuffer[offset + i * 2 + 1] = lookUpHexAlphabet[temp & 0xF];
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof BinaryHexValue) {
            return this._equals(((BinaryHexValue)o).bytes);
        }
        BinaryHexValue bv = BinaryHexValue.parse(o.toString());
        return bv == null ? false : this._equals(bv.bytes);
    }

    public int hashCode() {
        int hc = 0;
        byte[] byArray = this.bytes;
        int n = this.bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            hc = hc * 31 ^ b;
            ++n2;
        }
        return hc;
    }

    public static byte[] decode(String encoded) {
        if (encoded == null) {
            return null;
        }
        int lengthData = encoded.length();
        if (lengthData % 2 != 0) {
            return null;
        }
        char[] binaryData = encoded.toCharArray();
        int lengthDecode = lengthData / 2;
        byte[] decodedData = new byte[lengthDecode];
        int i = 0;
        while (i < lengthDecode) {
            int temp2;
            int temp1;
            char tempChar = binaryData[i * 2];
            int n = temp1 = tempChar < '\u0080' ? hexNumberTable[tempChar] : -1;
            if (temp1 == -1) {
                return null;
            }
            tempChar = binaryData[i * 2 + 1];
            int n2 = temp2 = tempChar < '\u0080' ? hexNumberTable[tempChar] : -1;
            if (temp2 == -1) {
                return null;
            }
            decodedData[i] = (byte)(temp1 << 4 | temp2);
            ++i;
        }
        return decodedData;
    }
}

