/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.strings;

import com.siemens.ct.exi.context.EncoderContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.strings.StringEncoderImpl;
import com.siemens.ct.exi.values.StringValue;

public class BoundedStringEncoderImpl
extends StringEncoderImpl {
    protected final int valueMaxLength;
    protected final int valuePartitionCapacity;
    protected int globalID;
    protected StringEncoderImpl.ValueContainer[] globalIdMapping;

    public BoundedStringEncoderImpl(boolean localValuePartitions, int valueMaxLength, int valuePartitionCapacity) {
        super(localValuePartitions);
        this.valueMaxLength = valueMaxLength;
        this.valuePartitionCapacity = valuePartitionCapacity;
        this.globalID = -1;
        if (valuePartitionCapacity >= 0) {
            this.globalIdMapping = new StringEncoderImpl.ValueContainer[valuePartitionCapacity];
        }
    }

    public void addValue(EncoderContext coder, QNameContext context, String value) {
        if (this.valueMaxLength < 0 || value.length() <= this.valueMaxLength) {
            if (this.valuePartitionCapacity < 0) {
                super.addValue(coder, context, value);
            } else if (this.valuePartitionCapacity != 0) {
                assert (!this.stringValues.containsKey(value));
                if (++this.globalID == this.valuePartitionCapacity) {
                    this.globalID = 0;
                }
                StringEncoderImpl.ValueContainer vc = new StringEncoderImpl.ValueContainer(value, context, coder.getNumberOfStringValues(context), this.globalID);
                if (this.stringValues.size() == this.valuePartitionCapacity) {
                    StringEncoderImpl.ValueContainer vcFree = this.globalIdMapping[this.globalID];
                    if (this.localValuePartitions) {
                        coder.freeStringValue(vcFree.context, vcFree.localValueID);
                    }
                    this.stringValues.remove(vcFree.value);
                }
                this.stringValues.put(value, vc);
                if (this.localValuePartitions) {
                    coder.addStringValue(context, new StringValue(value));
                }
                this.globalIdMapping[this.globalID] = vc;
            }
        }
    }

    public void clear() {
        super.clear();
        this.globalID = -1;
    }
}

