/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol;

import org.jnetpcap.Pcap;
import org.jnetpcap.PcapDLT;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.Payload;
import org.jnetpcap.protocol.application.Html;
import org.jnetpcap.protocol.application.WebImage;
import org.jnetpcap.protocol.lan.Ethernet;
import org.jnetpcap.protocol.lan.IEEE802dot1q;
import org.jnetpcap.protocol.lan.IEEE802dot2;
import org.jnetpcap.protocol.lan.IEEE802dot3;
import org.jnetpcap.protocol.lan.IEEESnap;
import org.jnetpcap.protocol.lan.NullHeader;
import org.jnetpcap.protocol.lan.SLL;
import org.jnetpcap.protocol.network.Arp;
import org.jnetpcap.protocol.network.Icmp;
import org.jnetpcap.protocol.network.Ip4;
import org.jnetpcap.protocol.network.Ip6;
import org.jnetpcap.protocol.sigtran.Sctp;
import org.jnetpcap.protocol.sigtran.SctpAbort;
import org.jnetpcap.protocol.sigtran.SctpCWR;
import org.jnetpcap.protocol.sigtran.SctpCookie;
import org.jnetpcap.protocol.sigtran.SctpCookieAck;
import org.jnetpcap.protocol.sigtran.SctpData;
import org.jnetpcap.protocol.sigtran.SctpECNE;
import org.jnetpcap.protocol.sigtran.SctpError;
import org.jnetpcap.protocol.sigtran.SctpHeartbeat;
import org.jnetpcap.protocol.sigtran.SctpHeartbeatAck;
import org.jnetpcap.protocol.sigtran.SctpInit;
import org.jnetpcap.protocol.sigtran.SctpInitAck;
import org.jnetpcap.protocol.sigtran.SctpSack;
import org.jnetpcap.protocol.sigtran.SctpShutdown;
import org.jnetpcap.protocol.sigtran.SctpShutdownAck;
import org.jnetpcap.protocol.sigtran.SctpShutdownComplete;
import org.jnetpcap.protocol.tcpip.Http;
import org.jnetpcap.protocol.tcpip.Tcp;
import org.jnetpcap.protocol.tcpip.Udp;
import org.jnetpcap.protocol.voip.RtcpApp;
import org.jnetpcap.protocol.voip.RtcpBye;
import org.jnetpcap.protocol.voip.RtcpReceiverReport;
import org.jnetpcap.protocol.voip.RtcpSDES;
import org.jnetpcap.protocol.voip.RtcpSenderReport;
import org.jnetpcap.protocol.voip.Rtp;
import org.jnetpcap.protocol.voip.Sdp;
import org.jnetpcap.protocol.voip.Sip;
import org.jnetpcap.protocol.vpn.L2TP;
import org.jnetpcap.protocol.wan.PPP;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JProtocol {
    PAYLOAD(0, Payload.class),
    ETHERNET(1, Ethernet.class, PcapDLT.EN10MB),
    IP4(2, Ip4.class),
    IP6(3, Ip6.class),
    TCP(4, Tcp.class),
    UDP(5, Udp.class),
    IEEE_802DOT3(6, IEEE802dot3.class, PcapDLT.IEEE802),
    IEEE_802DOT2(7, IEEE802dot2.class),
    IEEE_SNAP(8, IEEESnap.class),
    IEEE_802DOT1Q(9, IEEE802dot1q.class),
    L2TP(10, L2TP.class),
    PPP(11, PPP.class, PcapDLT.PPP),
    ICMP(12, Icmp.class),
    HTTP(13, Http.class),
    HTML(14, Html.class),
    WEB_IMAGE(15, WebImage.class),
    ARP(16, Arp.class),
    SIP(17, Sip.class),
    SDP(18, Sdp.class),
    RTP(48, Rtp.class),
    SLL(20, SLL.class, PcapDLT.LINUX_SLL),
    SCTP(32, Sctp.class),
    SCTP_DATA(33, SctpData.class),
    SCTP_INIT(34, SctpInit.class),
    SCTP_INIT_ACK(35, SctpInitAck.class),
    SCTP_SACK(36, SctpSack.class),
    SCTP_HEARTBEAT(37, SctpHeartbeat.class),
    SCTP_HEARTBEAT_ACK(38, SctpHeartbeatAck.class),
    SCTP_ABORT(39, SctpAbort.class),
    SCTP_SHUTDOWN(40, SctpShutdown.class),
    SCTP_SHUTDOWN_ACK(41, SctpShutdownAck.class),
    SCTP_ERROR(42, SctpError.class),
    SCTP_COOKIE(43, SctpCookie.class),
    SCTP_COOKIE_ACK(44, SctpCookieAck.class),
    SCTP_ECNE(45, SctpECNE.class),
    SCTP_CWR(46, SctpCWR.class),
    SCTP_SHUTDOWN_COMPLETE(47, SctpShutdownComplete.class),
    NULL_HEADER(21, NullHeader.class, PcapDLT.NULL),
    RTCP_SENDER_REPORT(49, RtcpSenderReport.class),
    RTCP_RECEIVER_REPORT(50, RtcpReceiverReport.class),
    RTCP_SDES(51, RtcpSDES.class),
    RTCP_BYE(52, RtcpBye.class),
    RTCP_APP(53, RtcpApp.class);

    private final int id;
    private Class<? extends JHeader> clazz;
    private final String className;
    private final PcapDLT[] dlt;
    private final long bitmask;
    private final int group;
    public static final long BITMASK_PROTCOL_MASK = 0xFFFFFFFFL;
    public static final long BITMASK_GROUP_MASK = -4294967296L;
    public static final int BITMAP_GROUP0 = 0;
    public static final int PAYLOAD_ID = 0;
    public static final int ETHERNET_ID = 1;
    public static final int IP4_ID = 2;
    public static final int IP6_ID = 3;
    public static final int TCP_ID = 4;
    public static final int UDP_ID = 5;
    public static final int IEEE_802DOT3_ID = 6;
    public static final int IEEE_802DOT2_ID = 7;
    public static final int IEEE_SNAP_ID = 8;
    public static final int IEEE_802DOT1Q_ID = 9;
    public static final int L2TP_ID = 10;
    public static final int PPP_ID = 11;
    public static final int ICMP_ID = 12;
    public static final int HTTP_ID = 13;
    public static final int HTML_ID = 14;
    public static final int WEB_IMAGE_ID = 15;
    public static final int ARP_ID = 16;
    public static final int SIP_ID = 17;
    public static final int SDP_ID = 18;
    public static final int SLL_ID = 20;
    public static final int NULL_HEADER_ID = 21;
    public static final int BITMAP_GROUP1 = 32;
    public static final int SCTP_ID = 32;
    public static final int SCTP_DATA_ID = 33;
    public static final int SCTP_INIT_ID = 34;
    public static final int SCTP_INIT_ACK_ID = 35;
    public static final int SCTP_SACK_ID = 36;
    public static final int SCTP_HEARTBEAT_ID = 37;
    public static final int SCTP_HEARTBEAT_ACK_ID = 38;
    public static final int SCTP_ABORT_ID = 39;
    public static final int SCTP_SHUTDOWN_ID = 40;
    public static final int SCTP_SHUTDOWN_ACK_ID = 41;
    public static final int SCTP_ERROR_ID = 42;
    public static final int SCTP_COOKIE_ID = 43;
    public static final int SCTP_COOKIE_ACK_ID = 44;
    public static final int SCTP_ECNE_ID = 45;
    public static final int SCTP_CWR_ID = 46;
    public static final int SCTP_SHUTDOWN_COMPLETE_ID = 47;
    public static final int RTP_ID = 48;
    public static final int RTCP_SENDER_REPORT_ID = 49;
    public static final int RTCP_RECEIVER_REPORT_ID = 50;
    public static final int RTCP_SDES_ID = 51;
    public static final int RTCP_BYE_ID = 52;
    public static final int RTCP_APP_ID = 53;
    public static final int BITMAP_GROUP2 = 64;
    public static final int LAST_ID = 64;

    private JProtocol(int n2, String string2) {
        this(n2, string2, new PcapDLT[0]);
    }

    private JProtocol(int n2, Class<? extends JHeader> clazz) {
        this(n2, clazz, new PcapDLT[0]);
    }

    private JProtocol(int n2, Class<? extends JHeader> clazz, PcapDLT ... pcapDLTArray) {
        this.clazz = clazz;
        this.className = clazz.getCanonicalName();
        this.dlt = pcapDLTArray;
        this.id = n2;
        this.bitmask = JProtocol.idToMask(n2);
        this.group = JProtocol.idToGroup(n2);
    }

    private JProtocol(int n2, String string2, PcapDLT ... pcapDLTArray) {
        this.className = string2;
        this.dlt = pcapDLTArray;
        this.id = n2;
        this.bitmask = JProtocol.idToMask(n2);
        this.group = JProtocol.idToGroup(n2);
        if (((Object)((Object)this)).getClass().getResource(string2) == null) {
            throw new IllegalStateException("unable to find class " + string2);
        }
    }

    public Class<? extends JHeader> getHeaderClass() {
        if (this.clazz == null) {
            try {
                this.clazz = Class.forName(this.className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException(classNotFoundException);
            }
        }
        return this.clazz;
    }

    public String getHeaderClassName() {
        return this.className;
    }

    public static boolean isCoreProtocol(int n) {
        return n < 64;
    }

    public static boolean isCoreProtocol(Class<? extends JHeader> clazz) {
        return JProtocol.valueOf(clazz) != null;
    }

    public static JProtocol valueOf(Class<? extends JHeader> clazz) {
        for (JProtocol jProtocol : JProtocol.values()) {
            if (jProtocol.clazz != clazz) continue;
            return jProtocol;
        }
        return null;
    }

    public static JProtocol valueOf(int n) {
        if (n >= JProtocol.values().length) {
            return null;
        }
        return JProtocol.values()[n];
    }

    public static JProtocol valueOf(Pcap pcap) {
        return JProtocol.valueOf(PcapDLT.valueOf(pcap.datalink()));
    }

    public static JProtocol valueOf(PcapDLT pcapDLT) {
        if (pcapDLT == null) {
            return PAYLOAD;
        }
        for (JProtocol jProtocol : JProtocol.values()) {
            for (PcapDLT pcapDLT2 : jProtocol.dlt) {
                if (pcapDLT != pcapDLT2) continue;
                return jProtocol;
            }
        }
        return PAYLOAD;
    }

    public PcapDLT[] getDlt() {
        return this.dlt;
    }

    public int getId() {
        return this.id;
    }

    public long getBitmask() {
        return this.bitmask;
    }

    public int getGroup() {
        return this.group;
    }

    public final Class<? extends JHeader> getClazz() {
        return this.clazz;
    }

    public static long idToMask(int n) {
        if (n < 0 || n >= 256) {
            throw new IllegalArgumentException("valid index values are between 0 and 256");
        }
        long l = n >> 5;
        long l2 = l << 32 | 1L << (n & 0x1F);
        return l2;
    }

    public static final int createId(int n, int n2) {
        return n << 5 | n2;
    }

    public static final int maskToGroup(long l) {
        return (int)(l >> 32);
    }

    public static final int idToGroup(int n) {
        return n >> 5;
    }

    public static int maskToId(long l) {
        int n = 32;
        if (l != 0L) {
            --n;
        }
        if ((l & 0xFFFFL) != 0L) {
            n -= 16;
        }
        if ((l & 0xFF00FFL) != 0L) {
            n -= 8;
        }
        if ((l & 0xF0F0F0FL) != 0L) {
            n -= 4;
        }
        if ((l & 0x33333333L) != 0L) {
            n -= 2;
        }
        if ((l & 0x55555555L) != 0L) {
            --n;
        }
        return (int)(l >> 37 | (long)n);
    }

    public static long createMaskFromMasks(long ... lArray) {
        long l = 0L;
        int n = JProtocol.maskToGroup(lArray[0]);
        for (long l2 : lArray) {
            if (JProtocol.maskToGroup(l2) != n) {
                throw new IllegalArgumentException("All masks must be in the same map-index");
            }
            l |= l2;
        }
        return l;
    }

    public static long createMaskFromProtocols(JProtocol ... jProtocolArray) {
        long l = 0L;
        int n = jProtocolArray[0].group;
        for (JProtocol jProtocol : jProtocolArray) {
            if (jProtocol.group != n) {
                throw new IllegalArgumentException("All protocols must be in the same bitmap-group");
            }
            l |= jProtocol.bitmask;
        }
        return l;
    }

    public static long createMaskFromIds(int ... nArray) {
        long l = 0L;
        int n = JProtocol.idToGroup(nArray[0]);
        for (int n2 : nArray) {
            long l2 = JProtocol.idToMask(n2);
            if (JProtocol.maskToGroup(l2) != n) {
                throw new IllegalArgumentException("All ids must be in the same bitmap-group");
            }
            l |= l2;
        }
        return l;
    }

    public static interface Suite {
        public String name();
    }
}

