/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import java.nio.ByteBuffer;
import org.jnetpcap.JCaptureHeader;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.PeeringException;
import org.jnetpcap.packet.format.FormatUtils;

public class JMemoryPacket
extends JPacket {
    private final JMemoryHeader header = new JMemoryHeader();

    public JMemoryPacket(byte[] byArray) {
        super(JMemory.Type.POINTER);
        JBuffer jBuffer = this.getMemoryBuffer(byArray);
        super.peer(jBuffer);
        this.header.setWirelen(byArray.length);
    }

    public JMemoryPacket(ByteBuffer byteBuffer) throws PeeringException {
        super(JMemory.Type.POINTER);
        int n = byteBuffer.limit() - byteBuffer.position();
        JBuffer jBuffer = this.getMemoryBuffer(n);
        super.peer(jBuffer);
        this.transferFrom(byteBuffer);
        this.header.setWirelen(n);
    }

    public JMemoryPacket(int n) {
        super(n, 0);
        this.header.setWirelen(n);
        super.peer(this.memory);
    }

    public JMemoryPacket(int n, byte[] byArray) {
        this(byArray);
        this.scan(n);
    }

    public JMemoryPacket(int n, ByteBuffer byteBuffer) throws PeeringException {
        this(byteBuffer);
        this.scan(n);
    }

    public JMemoryPacket(int n, JBuffer jBuffer) {
        this(jBuffer);
        this.scan(n);
    }

    public JMemoryPacket(int n, String string) {
        this(n, FormatUtils.toByteArray(string));
    }

    public JMemoryPacket(JBuffer jBuffer) {
        super(POINTER);
        this.header.setWirelen(jBuffer.size());
        int n = jBuffer.size();
        JBuffer jBuffer2 = this.getMemoryBuffer(n);
        jBuffer2.transferFrom(jBuffer);
        this.peer(jBuffer2, 0, n);
        this.header.setWirelen(n);
    }

    public JMemoryPacket(JMemoryPacket jMemoryPacket) {
        super(JMemory.Type.POINTER);
        this.transferFrom(jMemoryPacket);
    }

    public JMemoryPacket(JPacket jPacket) {
        super(JMemory.Type.POINTER);
        this.transferFrom(jPacket);
    }

    public JMemoryPacket(JMemory.Type type) {
        super(type);
    }

    public JMemoryHeader getCaptureHeader() {
        return this.header;
    }

    public int getTotalSize() {
        return super.size() + this.state.size();
    }

    public int peerStateAndData(ByteBuffer byteBuffer) throws PeeringException {
        if (!byteBuffer.isDirect()) {
            throw new PeeringException("unable to peer a non-direct ByteBuffer");
        }
        return this.peerStateAndData(this.getMemoryBuffer(byteBuffer), 0);
    }

    public int peerStateAndData(JBuffer jBuffer) {
        return this.peerStateAndData(this.getMemoryBuffer(jBuffer), 0);
    }

    public int peerStateAndData(JBuffer jBuffer, int n) {
        this.state.peerTo(jBuffer, n, JPacket.State.sizeof(0));
        int n2 = this.state.peerTo(jBuffer, n, JPacket.State.sizeof(this.state.getHeaderCount()));
        n2 += super.peer(jBuffer, n + n2, this.header.caplen());
        return n2;
    }

    public void setWirelen(int n) {
        this.header.setWirelen(n);
    }

    public int transferStateAndDataFrom(byte[] byArray) {
        JBuffer jBuffer = this.getMemoryBuffer(byArray);
        return this.peerStateAndData(jBuffer, 0);
    }

    public int transferStateAndDataFrom(ByteBuffer byteBuffer) {
        int n = byteBuffer.limit() - byteBuffer.position();
        JBuffer jBuffer = this.getMemoryBuffer(n);
        jBuffer.transferFrom(byteBuffer, 0);
        return this.peerStateAndData(jBuffer, 0);
    }

    public int transferStateAndDataFrom(JBuffer jBuffer) {
        int n = jBuffer.size();
        JBuffer jBuffer2 = this.getMemoryBuffer(n);
        jBuffer2.transferFrom(jBuffer);
        return this.peerStateAndData(jBuffer2, 0);
    }

    public int transferStateAndDataFrom(JMemoryPacket jMemoryPacket) {
        return jMemoryPacket.transferTo(this);
    }

    public int transferStateAndDataFrom(JPacket jPacket) {
        int n = jPacket.state.size() + jPacket.size();
        JBuffer jBuffer = this.getMemoryBuffer(n);
        int n2 = jPacket.state.transferTo(jBuffer, 0, jPacket.state.size(), 0);
        n2 += jPacket.transferTo(jBuffer, 0, jPacket.size(), n2);
        return n2;
    }

    public int transferStateAndDataTo(JBuffer jBuffer, int n) {
        int n2 = this.state.transferTo(jBuffer, 0, this.state.size(), n);
        n2 += super.transferTo(jBuffer, 0, this.size(), n + n2);
        return n2;
    }

    public int transferStateAndDataTo(JMemoryPacket jMemoryPacket) {
        JBuffer jBuffer = jMemoryPacket.getMemoryBuffer(this.getTotalSize());
        jMemoryPacket.transferStateAndDataTo(jBuffer, 0);
        return this.peerStateAndData(jBuffer, 0);
    }

    public static class JMemoryHeader
    implements JCaptureHeader {
        private int caplen;
        private long inMicros;
        private long inMillis;
        private long inNanos;
        private long nanos;
        private long seconds;
        private int wirelen;

        public JMemoryHeader() {
            this(0, 0, System.currentTimeMillis() / 1000L, System.nanoTime());
        }

        public JMemoryHeader(int n, int n2, long l, long l2) {
            this.init(n, n2, l2, l);
        }

        public int caplen() {
            return this.caplen;
        }

        public void caplen(int n) {
            this.caplen = n;
            if (this.wirelen == 0) {
                this.setWirelen(n);
            }
        }

        public final int getWirelen() {
            return this.wirelen;
        }

        public void init(int n, int n2, long l, long l2) {
            this.caplen = n;
            this.wirelen = n2;
            this.nanos = l;
            this.seconds = l2;
            this.initCompound();
        }

        private void initCompound() {
            this.inMillis = this.seconds * 1000L + this.nanos / 1000000L;
            this.inMicros = this.seconds * 1000000L + this.nanos / 1000L;
            this.inNanos = this.seconds * 1000000000L + this.nanos;
        }

        public void initFrom(JCaptureHeader jCaptureHeader) {
            this.init(jCaptureHeader.caplen(), jCaptureHeader.wirelen(), jCaptureHeader.nanos(), jCaptureHeader.seconds());
        }

        public long nanos() {
            return this.nanos;
        }

        public void nanos(long l) {
            this.nanos = l;
            this.initCompound();
        }

        public long seconds() {
            return this.seconds;
        }

        public void seconds(long l) {
            this.seconds = l;
            this.initCompound();
        }

        public final void setWirelen(int n) {
            this.wirelen = n;
            if (this.caplen == 0) {
                this.caplen = n;
            }
        }

        public long timestampInMicros() {
            return this.inMicros;
        }

        public long timestampInMillis() {
            return this.inMillis;
        }

        public long timestampInNanos() {
            return this.inNanos;
        }

        public int wirelen() {
            return this.wirelen;
        }

        public void wirelen(int n) {
            this.wirelen = n;
        }
    }
}

