/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region.shape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.PolygonPoint;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.PolygonUtils;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */

public class Polygon {

	protected final List<PolygonPoint> linkedPoints = new ArrayList<PolygonPoint>();

	private final List<Polygon> holes = new ArrayList<Polygon>();

	/**
	 * 
	 */
	public Polygon() {
		// TODO Auto-generated constructor stub
	}


	/**
		 * 
		 */
	public Polygon(Polygon polygon) {
		linkedPoints.addAll(polygon.getLinkedPoints());
		holes.addAll(polygon.getHoles());
	}

	/**
	 * @param polygonPath
	 */
	public Polygon(PolygonPoint[] polygonPath) {
		linkedPoints.addAll(Arrays.asList(polygonPath));
	}


	public List<LineSegment> getEdges() {

		return getEdges(0);
	}

	public List<LineSegment> getEdges(int start) {
		List<LineSegment> edges = new ArrayList<LineSegment>();

		int numberOfPoints = linkedPoints.size();
		int end = (start + numberOfPoints);
		while (start < end) {
			LineSegment segment = new LineSegment(get(start % numberOfPoints), get((start + 1)
					% numberOfPoints));
			edges.add(segment);
			start++;
		}

		return edges;
	}


	public Polygon(List<PolygonPoint> polygonPoints) {
		linkedPoints.addAll(polygonPoints);
	}


	public boolean add(PolygonPoint p) {
		return linkedPoints.add(p);
	}

	/**
	 * @param vector2d
	 * @param i
	 */
	public void insert(PolygonPoint pp, int i) {
		if (!linkedPoints.contains(pp)) {
			linkedPoints.add(i, pp);
		}
	}

	/**
	 * @param i
	 * @return
	 */
	private PolygonPoint get(int i) {
		return linkedPoints.get(i);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("Polygon [\n");
		for (PolygonPoint pp : linkedPoints) {
			sb.append("- " + pp + "\n");
		}
		sb.append("]\n");
		return sb.toString();
	}

	/**
	 * Converts a chain of vertices ({@link Vector2d}) to edges ({@link HashMap}
	 * with the startpoint as key and the endpoint as value)
	 * 
	 * <pre>
	 * Vector2d[]{V1, V2, V3, V4} --> HashMap{V1=>V2, V2=>V3, V3=>V4, V4=>V1}
	 * 
	 * <pre>
	 * 
	 * @param vertices a list of veritces
	 * @return a map of edges
	 */
	public static List<LineSegment> verticesAsEdges(DoubleVector2d[] vertices) {

		if (vertices == null) {
			throw new IllegalArgumentException("Argument <vertices> may not be null.");
		}
		if (vertices.length < 2) {
			throw new IllegalArgumentException("The size of <vertices> needs to be at least 2.");
		}
		List<LineSegment> edges = new ArrayList<LineSegment>();

		int i, j;
		int n = vertices.length;
		for (i = 0, j = n - 1; i < n; j = i++) {
			edges.add(new LineSegment(vertices[j], vertices[i]));
		}

		return edges;
	}

	/**
	 * @return
	 */
	public List<PolygonPoint> getLinkedPoints() {
		return linkedPoints;
	}

	/**
	 * @param i
	 * @param j
	 * @return
	 */
	public static Polygon create(double... xy) {
		if (xy == null || xy.length <= 0 || xy.length % 2 == 1)
			throw new IllegalArgumentException("invalid input");

		Polygon p = new Polygon();
		for (int i = 0; i < xy.length; i = i + 2) {
			p.add(new PolygonPoint(xy[i], xy[i + 1]));

		}
		return p;
	}

	/**
	 * @return the holes
	 */
	public List<Polygon> getHoles() {
		return holes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((holes == null) ? 0 : holes.hashCode());
		result = prime * result + ((linkedPoints == null) ? 0 : linkedPoints.hashCode());
		return result;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Polygon other = (Polygon) obj;
		return PolygonUtils.equals(this, other);
	}

}
