/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region.shape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class Matrix {

	private ArrayList<ArrayList<Double>> matrix = new ArrayList<ArrayList<Double>>();
	private boolean swapLeft = false;

	public Matrix(Double[][] matrix) {
		for (Double[] doubles : matrix) {
			this.matrix.add(new ArrayList<Double>(Arrays.asList(doubles)));
		}
	}

	public Matrix(ArrayList<ArrayList<Double>> matrix) {
		this.matrix = matrix;
	}

	public void prepareMatrix() {
		double greatest = matrix.get(0).get(0);
		int operation = 0;
		for (int i = 0; i < matrix.size(); i++) {
			for (int j = 0; j < matrix.get(0).size() - 1; j++) {
				if (Math.abs(matrix.get(i).get(j)) > greatest) {
					operation = 2 * i + j;
				}
			}
		}
		if ((operation & 0x01) == 1) {
			swapLeft = true;
			swapLeft();
		}

		if ((operation & 0x02) == 2) {
			swapUp();
		}
	}

	/**
	 * @param matrix
	 */
	private void swapUp() {
		swap(matrix, 0, 1);
	}

	private <T> void swap(List<?> lst, int pos1, int pos2) {
		Collections.swap(lst, pos1, pos2);
	}

	/**
	 * @param matrix
	 */
	private void swapLeft() {

		for (int i = 0; i < matrix.size(); i++) {
			swap(matrix.get(i), 0, 1);
		}
	}

	public Double[] solve() {

//		System.out.println(toString());
		prepareMatrix();
//		System.out.println(toString());
		double[] factor = new double[] { get(0, 0), get(1, 0) };
		set(1, 0, factor[0] * get(1, 0) - factor[1] * get(0, 0));
		set(1, 1, factor[0] * get(1, 1) - factor[1] * get(0, 1));
		set(1, 2, factor[0] * get(1, 2) - factor[1] * get(0, 2));
//		System.out.println(toString());
		if (get(1, 1) == 0.0)
			return null;

		Double[] solved = new Double[2];
		double t = get(1, 2) / get(1, 1);
		solved[swapLeft ? 0 : 1] = t;
		solved[swapLeft ? 1 : 0] = (get(0, 2) - t * get(0, 1)) / get(0, 0);

//		System.out.println(Arrays.toString(solved));
		return solved;
	}

	public void set(int i, int j, Double value) {
		matrix.get(i).add(j, value);
		matrix.get(i).remove(j + 1);
	}

	public Double get(int i, int j) {
		return matrix.get(i).get(j);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < matrix.size(); i++) {
			sb.append(String.format("%g %g | %g\n", matrix.get(i).get(0), matrix
					.get(i).get(1), matrix.get(i).get(2)));
		}
		return sb.toString();
	}

	public static Matrix createFromValues(Double... args) {
		Double[][] matrix = new Double[args.length / 3][];
		for (int i = 0; i < matrix.length; i++) {
			Double[] values = new Double[3];
			for (int j = 0; j < values.length; j++) {
				values[j] = args[3 * i + j];
			}
			matrix[i] = values;
		}
		return new Matrix(matrix);
	}

	/**
	 * @return the swapLeft
	 */
	public boolean isSwapLeft() {
		return swapLeft;
	}
}
