/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region.shape;

import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.LinearMath.StraightLine;


/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class LineSegment extends StraightLine {

	private final DoubleVector2d start;
	private final DoubleVector2d end;

	/**
	 * 
	 */
	public LineSegment(DoubleVector2d start, DoubleVector2d end) {
		super(start, end.sub(start));
		this.start = start;
		this.end = end;

	}

	/**
	 * @return the start
	 */
	public DoubleVector2d getStart() {
		return start;
	}

	/**
	 * @return the end
	 */
	public DoubleVector2d getEnd() {
		return end;
	}

	/**
	 * @param pointToCheck
	 * @return
	 */
	public boolean isOn(DoubleVector2d pointToCheck) {
		if (!((start.getY() >= pointToCheck.getY() && pointToCheck.getY() >= end.getY()) || (end.getY() >= pointToCheck
				.getY() && pointToCheck.getY() >= start.getY()))) {
			return false;
		}

		return super.isOn(pointToCheck);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "["+start+" --> "+end+"]";
	}
}
