/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region;

import javax.inject.Inject;

import org.apache.log4j.Logger;

import de.fraunhofer.sit.c2x.pki.ca.core.logging.InjectLogger;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.IdentifiedRegion;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class IdIdValidator extends AbstractIdValidator<IdentifiedRegion> {

	@InjectLogger
	private Logger logger;

	@Inject
	public IdIdValidator() {
		super();
	}

	/**
	 * @param idRegion
	 */
	public IdIdValidator(IdentifiedRegion idRegion) {
		super(idRegion);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.preserve.pki.ca.validator.Validator#validate(java.lang.Object)
	 */
	@Override
	public boolean validate(IdentifiedRegion regionToValidate) {
		if (regionToValidate == null)
			throw new IllegalArgumentException("<regionToValidate> may not be null");

		if (dictionary != regionToValidate.getRegionDictionary()) {
			logger.warn("RegionDictionary does not match: expected=" + dictionary + ", actual="
					+ regionToValidate.getRegionDictionary());
			return false;
		}

		if (globalRegion != regionToValidate.getGlobalRegionId()) {
			logger.warn("GlobalRegionId does not match: expected=" + globalRegion + ", actual="
					+ regionToValidate.getGlobalRegionId());
			return false;
		}

		if (localRegion != regionToValidate.getLocalRegionId()) {
			logger.warn("LocalRegionId does not match: expected=" + localRegion + ", actual="
					+ regionToValidate.getLocalRegionId());
			return false;
		}

		return true;
	}

}
