/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region;

import javax.inject.Inject;

import org.apache.log4j.Logger;

import de.fraunhofer.sit.c2x.pki.ca.core.logging.InjectLogger;
import de.fraunhofer.sit.c2x.pki.ca.validator.Validator;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.GeographicRegion;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.RectangularRegion;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class GeorgraphicRegionValidator implements Validator<GeographicRegion> {

	private GeographicRegion region;

	@InjectLogger
	private Logger logger;

	@Inject
	private CircleCircleValidator circleCircleValidator;

	@Inject
	private RectangleRectangleValidator rectangleRectangleValidator;

	@Inject
	private PolygonPolygonValidator polygonPolygonValidator;

	@Inject
	private IdIdValidator idIdValidator;

	@Inject
	public GeorgraphicRegionValidator() {
	}

	/**
	 * @param circularRegion
	 */
	public GeorgraphicRegionValidator(GeographicRegion region) {
		setRegion(region);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.preserve.pki.ca.validator.Validator#validate(java.lang.Object)
	 */
	@Override
	public boolean validate(GeographicRegion object) {

		if (region == null) {
			logger.warn("No CA Region set!");
			return false;
		} else {
			if (logger.isTraceEnabled())
				logger.trace("CA Region: " + region);
		}

		if (object == null) {
			if (logger.isDebugEnabled())
				logger.debug("Region to validate is null");
			return false;
		} else {
			if (logger.isTraceEnabled())
				logger.trace("Region to validate: " + object);
		}

		if (region.getICircularRegion() == null && region.getIIdRegion() == null
				&& region.getIPolygonalRegion() == null && region.getIRectangularRegion() == null) {
			if (logger.isDebugEnabled())
				logger.debug("CA-Region is NONE");
			return true;
		}

		if (region.getICircularRegion() != null && object.getICircularRegion() != null) {
			if (logger.isDebugEnabled())
				logger.debug("Region-Check started: Circle-Circle");
			circleCircleValidator.setRegion(region.getICircularRegion());
			return circleCircleValidator.validate(object.getICircularRegion());

		}

		else if (region.getIIdRegion() != null && object.getIIdRegion() != null) {
			if (logger.isDebugEnabled())
				logger.debug("Region-Check started: Id-Id");
			idIdValidator.setRegion(region.getIIdRegion());
			return idIdValidator.validate(object.getIIdRegion());
		}

		else if (region.getIRectangularRegion() != null && object.getIRectangularRegion() != null) {
			if (logger.isDebugEnabled())
				logger.debug("Region-Check started: Rectangle-Rectangle");
			for (RectangularRegion r : object.getIRectangularRegion()) {
				rectangleRectangleValidator.setRegions(region.getIRectangularRegion());
				return rectangleRectangleValidator.validate(r);
			}

		}

		else if (region.getIPolygonalRegion() != null && object.getIPolygonalRegion() != null) {
			if (logger.isDebugEnabled())
				logger.debug("Region-Check started: Polygonal-Polygonal");
			polygonPolygonValidator.setRegion(region.getIPolygonalRegion());
			return polygonPolygonValidator.validate(object.getIPolygonalRegion());
		}

		else if (logger.isDebugEnabled())
			logger.warn("Region-Check not suppored as region restriction type of issuer is different than requested region restriction type.");

		return false;
	}

	public void setRegion(GeographicRegion region) {
		this.region = region;
	}
}
