/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region;

import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.CircularRegion;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.PolygonalRegion;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.TwoDLocation;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.shape.DoubleVector2d;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.shape.Polygon;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.Convert;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.LinearMath;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.PolygonPoint;


/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class CirclePolygonValidator extends AbstractCircleValidator<PolygonalRegion> {

	/**
	 * 
	 */
	public CirclePolygonValidator(CircularRegion circularRegion) {
		super(circularRegion);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.preserve.pki.ca.validator.Validator#validate(java.lang.Object)
	 */
	@Override
	public boolean validate(PolygonalRegion regionToValidate) {

		if (regionToValidate == null)
			throw new IllegalArgumentException("<regionToValidate> may not be null");

		Polygon polygon = convertPolygonalRegion(regionToValidate);

		return validate(polygon);
	}

	private Polygon convertPolygonalRegion(PolygonalRegion region) {
		Polygon poly = new Polygon();
		TwoDLocation[] wgsPoints = region.getPolygonalRegion();
		for (TwoDLocation twoDLocation : wgsPoints) {
			DoubleVector2d vector = Convert.aTwoDLocation.toVector(twoDLocation);
			poly.add(new PolygonPoint(vector));
		}
		return poly;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.preserve.pki.ca.validator.Validator#validate(java.lang.Object)
	 */
	public boolean validate(Polygon regionToValidate) {

		if (regionToValidate == null)
			throw new IllegalArgumentException("<regionToValidate> may not be null");

		for (PolygonPoint pp : regionToValidate.getLinkedPoints()) {
			if (Convert.round(LinearMath.distanceBetween(caCenter, pp), 0) > caRadius) {
				return false;
			}
		}

		return true;
	}

}
