/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region;

import de.fraunhofer.sit.c2x.pki.ca.validator.Validator;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.PolygonalRegion;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.TwoDLocation;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.shape.Polygon;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.Convert;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.PolygonPoint;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public abstract class AbstractPolygonValidator<T> implements Validator<T> {

	protected Polygon caPolygon;

	public AbstractPolygonValidator() {
	}

	public AbstractPolygonValidator(PolygonalRegion polygonalRegion) {
		setRegion(polygonalRegion);
	}

	public static Polygon convertToPolygon(PolygonalRegion region) {
		PolygonPoint[] polyPoints = new PolygonPoint[region.getPolygonalRegion().length];
		int i = 0;
		String zone = null;
		for (TwoDLocation twoDLocation : region.getPolygonalRegion()) {
			String z = Convert.aTwoDLocation.toUTM(twoDLocation).getZone();
			if (zone == null)
				zone = z;
			else if (zone.equals(z) == false)
				throw new IllegalArgumentException(
						"Points of polygon are not in the same UTM zone. Indentitied different UTM zones: "
								+ zone + ", " + z);

			polyPoints[i++] = new PolygonPoint(Convert.aTwoDLocation.toVector(twoDLocation));
		}

		return new Polygon(polyPoints);
	}

	public void setRegion(PolygonalRegion polygonalRegion) {
		if (polygonalRegion == null) {
			throw new IllegalArgumentException("<polygonalRegion> may not be null");
		}
		caPolygon = convertToPolygon(polygonalRegion);
	}
}
