/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region;

import de.fraunhofer.sit.c2x.pki.ca.validator.Validator;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.IdentifiedRegion;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public abstract class AbstractIdValidator<T> implements Validator<T> {

	protected int dictionary;
	protected long globalRegion;
	protected long localRegion;

	public AbstractIdValidator() {
	}

	/**
	 * 
	 */
	public AbstractIdValidator(IdentifiedRegion idRegion) {
		if (idRegion == null) {
			throw new IllegalArgumentException("<circularRegion> may not be null");
		}
		setRegion(idRegion);

	}

	public void setRegion(IdentifiedRegion idRegion) {
		this.dictionary = idRegion.getRegionDictionary();
		this.globalRegion = idRegion.getGlobalRegionId();
		this.localRegion = idRegion.getLocalRegionId();
	}

}
