/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region;

import de.fraunhofer.sit.c2x.pki.ca.validator.Validator;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.CircularRegion;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.shape.DoubleVector2d;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.Convert;


/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public abstract class AbstractCircleValidator<T> implements Validator<T> {

	protected DoubleVector2d caCenter;
	protected int caRadius;

	/**
	 * 
	 */
	public AbstractCircleValidator(CircularRegion circularRegion) {
		setRegion(circularRegion);
	}
	
	public AbstractCircleValidator() {
	}
	
	public void setRegion(CircularRegion circularRegion) {
		if (circularRegion == null) {
			throw new IllegalArgumentException("<circularRegion> may not be null");
		}
		caCenter = Convert.aTwoDLocation.toVector(circularRegion.getCenter());
		caRadius = circularRegion.getRadiusInt();
	}

}
