package de.fraunhofer.sit.c2x.pki.ca.utils;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

import de.fraunhofer.sit.c2x.pki.ca.core.Validate;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class DateUtils {

	/**
	 * 
	 * @param datetime
	 * @return
	 */
	public static DateTime floorDay(DateTime datetime) {
		Validate.arg(datetime, "datetime").isNotNull();
	
		return new DateTime(datetime.getYear(), datetime.getMonthOfYear(), datetime.getDayOfMonth(), 0, 0, 0,
				0, DateTimeZone.UTC);
	}

}
