package de.fraunhofer.sit.c2x.pki.ca.provider.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.Constants;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.DBInterval;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.DBIntervalId;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.PPEExtendedProvider;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class JDBCPPEExtentedProvider extends AbstractMysqlConnection implements PPEExtendedProvider {

	public DBInterval[] getAll(byte[] certId) throws ProviderException {
		String sql = String.format("SELECT * FROM %s WHERE %s = ? ORDER BY %s ASC", Constants.SLOT__TABLE,
				Constants.SLOT__ID__CERT_ID, Constants.SLOT__ID__REGION, Constants.SLOT__COL__CREATION_TIME);
		Connection con = getConnection();
		PreparedStatement st = null;
		ResultSet result = null;
		try {
			st = con.prepareStatement(sql);
			st.setBytes(1, certId);

			st.execute();
			result = st.getResultSet();

			List<DBInterval> tmp = new ArrayList<>();
			while (result.next()) {
				DBInterval info = new DBInterval();
				DBIntervalId id = new DBIntervalId(result.getBytes(Constants.SLOT__ID__CERT_ID),
						result.getBytes(Constants.SLOT__ID__REGION),
						result.getLong(Constants.SLOT__ID__START_TIME),
						result.getLong(Constants.SLOT__ID__END_TIME));
				info.setId(id);
				info.setRequestHash(result.getBytes(Constants.SLOT__COL__REQUEST_HASH));
				info.setCreationTime(result.getTimestamp(Constants.SLOT__COL__CREATION_TIME,
						Calendar.getInstance(TimeZone.getTimeZone("UTC"))));
				info.setActivatedCerts(result.getInt(Constants.SLOT__COL__ACTIVATED_CERTS));
				info.setReservedCerts(result.getInt(Constants.SLOT__COL__RESERVED));
				tmp.add(info);
			}
			return tmp.toArray(new DBInterval[tmp.size()]);
		} catch (SQLException e) {
			e.printStackTrace();
			throw new ProviderException("Can not get all time slots from DB", e);
		} finally {
			closeStatement(st);
			closeConnection(con);
			closeResultSet(result);
		}
	}

	@Override
	public String getName() {
		return "PPEExtendedProvider";
	}

	@Override
	public void remove(byte[] certId) throws ProviderException {
		String sql = "";
		sql = String
				.format("DELETE FROM %s WHERE %s = ?", Constants.SLOT__TABLE, Constants.SLOT__ID__CERT_ID);
		Connection con = getConnection();
		PreparedStatement st = null;
		ResultSet result = null;
		try {
			st = con.prepareStatement(sql);
			st.setBytes(1, certId);

			st.execute();
		} catch (SQLException e) {
			e.printStackTrace();
			throw new ProviderException("Can not delete intervals from DB", e);
		} finally {
			closeStatement(st);
			closeConnection(con);
			closeResultSet(result);
		}

	}

	@Override
	public DBIntervalId[] getList(int startIndex, int limit) throws ProviderException {
		String sql = String.format("SELECT DISTINCT %s, %s FROM %s ORDER BY %s DESC LIMIT %d, %d",
				Constants.SLOT__ID__CERT_ID, Constants.SLOT__ID__REGION, Constants.SLOT__TABLE,
				Constants.SLOT__COL__CREATION_TIME, startIndex, limit);
		Connection con = getConnection();
		PreparedStatement st = null;
		ResultSet result = null;
		try {
			st = con.prepareStatement(sql);

			st.execute();
			result = st.getResultSet();

			List<DBIntervalId> tmp = new ArrayList<>();
			while (result.next()) {
				DBIntervalId id = new DBIntervalId(result.getBytes(Constants.SLOT__ID__CERT_ID),
						result.getBytes(Constants.SLOT__ID__REGION), 0, 0);
				tmp.add(id);
			}
			return tmp.toArray(new DBIntervalId[tmp.size()]);
		} catch (SQLException e) {
			e.printStackTrace();
			throw new ProviderException("Can not get all time slots from DB", e);
		} finally {
			closeStatement(st);
			closeConnection(con);
			closeResultSet(result);
		}
	}

	@Override
	public DBIntervalId[] getList(byte[] certId) throws ProviderException {
		String sql = String.format("SELECT DISTINCT %s, %s FROM %s WHERE %s = ? ORDER BY %s DESC",
				Constants.SLOT__ID__CERT_ID, Constants.SLOT__ID__REGION, Constants.SLOT__TABLE,
				Constants.SLOT__ID__CERT_ID, Constants.SLOT__COL__CREATION_TIME);
		Connection con = getConnection();
		PreparedStatement st = null;
		ResultSet result = null;
		try {
			st = con.prepareStatement(sql);
			st.setBytes(1, certId);
			st.execute();
			result = st.getResultSet();

			List<DBIntervalId> tmp = new ArrayList<>();
			while (result.next()) {
				DBIntervalId id = new DBIntervalId(result.getBytes(Constants.SLOT__ID__CERT_ID),
						result.getBytes(Constants.SLOT__ID__REGION), 0, 0);
				tmp.add(id);
			}
			return tmp.toArray(new DBIntervalId[tmp.size()]);
		} catch (SQLException e) {
			e.printStackTrace();
			throw new ProviderException("Can not get all time slots from DB", e);
		} finally {
			closeStatement(st);
			closeConnection(con);
			closeResultSet(result);
		}
	}

}
