package de.fraunhofer.sit.c2x.pki.ca.provider.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.codec.binary.Hex;

import com.google.inject.Inject;

import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.Constants;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.IssuedCertificateInfo;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.IssuedCertificateInfoLink;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.IssuedCertsWithIdkInfoProvider;
import de.fraunhofer.sit.c2x.pki.ca.utils.ByteUtils;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class JDBCIssuedCertsInfoWithIdkProvider extends
		JDBCIssuedCertsInfoProvider implements IssuedCertsWithIdkInfoProvider {

	@Inject
	public JDBCIssuedCertsInfoWithIdkProvider() {
	}

	@Override
	public String getName() {
		return "Issued Certs With Idk Provider";
	}

	@Override
	public byte[] getIdk(byte[] certId) throws ProviderException {
		String sql = String.format("SELECT * FROM %s WHERE %s = ?;",
				Constants.ISSUED_CERTIFICATE_INFO_LINK__TABLE,
				Constants.ISSUED_CERTIFICATE_INFO__COL__ID);
		Connection con = getConnection();
		PreparedStatement st = null;
		ResultSet result = null;
		try {
			st = con.prepareStatement(sql);
			st.setBytes(1, certId);
			st.execute();
			result = st.getResultSet();

			if (!result.first()) {
				throw new ProviderException("Entry not found!");
			} else {
				
				return result.getBytes(Constants.AUTHORIZED_DEVICES__COL__ID);
			}
		} catch (SQLException e) {
			throw new ProviderException("c"
					+ "Can not get IDK of the issued certificate with Id="+ByteUtils.getHex(certId)+" from DB", e);
		} finally {
			closeStatement(st);
			closeConnection(con);
			closeResultSet(result);
		}
	}

	@Override
	public void save(IssuedCertificateInfo info, byte[] idk)
			throws ProviderException {

		super.save(info);
		String sql = String
				.format("INSERT INTO %s (%s, %s) VALUES (?,?);",
						Constants.ISSUED_CERTIFICATE_INFO_LINK__TABLE,
						Constants.ISSUED_CERTIFICATE_INFO__COL__ID,
						Constants.AUTHORIZED_DEVICES__COL__ID);
		Connection con = getConnection();
		PreparedStatement st = null;
		try {
			st = con.prepareStatement(sql);
			st.setBytes(1, info.getCertId());
			st.setBytes(2, idk);
			st.execute();
		} catch (SQLException e) {
			throw new ProviderException("Can not prepare statement", e);
		} finally {
			closeStatement(st);
			closeConnection(con);
		}
	}

	@Override
	public IssuedCertificateInfoLink[] getCerts(byte[] canonicalId, int offset, int limit)
			throws ProviderException {
		String sql = String.format(
				"SELECT * FROM %s WHERE HEX(%s) = \"%s\" ORDER BY %s DESC LIMIT %d, %d",
				Constants.ISSUED_CERTIFICATE_INFO_LINK__TABLE,
				Constants.AUTHORIZED_DEVICES__COL__ID,
				Hex.encodeHexString(canonicalId),
				Constants.ISSUED_CERTIFICATE_INFO__COL__ID, offset,
				limit);
		Connection con = getConnection();
		PreparedStatement st = null;
		ResultSet result = null;
		try {
			st = con.prepareStatement(sql);
			st.execute();
			result = st.getResultSet();

			List<IssuedCertificateInfoLink> tmp = new ArrayList<>();
			while (result.next()) {
				IssuedCertificateInfoLink info = new IssuedCertificateInfoLink();
				info.setCanonicalId(result.getBytes(Constants.AUTHORIZED_DEVICES__COL__ID));
				info.setCertId(result.getBytes(Constants.ISSUED_CERTIFICATE_INFO__COL__ID));
				tmp.add(info);
			}
			return tmp.toArray(new IssuedCertificateInfoLink[tmp.size()]);
		} catch (SQLException e) {
			throw new ProviderException("c"
					+ "Can not get ITS-S cononical ID <-> LTC linking information from DB", e);
		} finally {
			closeStatement(st);
			closeConnection(con);
			closeResultSet(result);
		}
	}

	

}
