package de.fraunhofer.sit.c2x.pki.ca.provider.interfaces;

import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;



/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public interface UpdateableCrlProvider<CrlType, RevokedInfoType, CertificateType> extends CrlProvider<CrlType> {

	void save(CrlType rev);

	RevokedInfoType[] getRevokedCerts();

	void revoke(RevokedInfoType cert);

	boolean removeRevokedCertificate(byte[] certId);
	
	public CertificateType getCertificate();

	void setCertificate(CertificateType cert) throws ProviderException;

}
