package de.fraunhofer.sit.c2x.pki.ca.provider.interfaces;

import de.fraunhofer.sit.c2x.pki.ca.core.interfaces.Service;
import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.DBInterval;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public interface PseudonymPolicyEnforcementProvider extends Service {

	/**
	 * Fetch all relevant Intervalls
	 * 
	 * @param certId certificate id
	 * @param region not used
	 * @param start starttime (millis)
	 * @param end endtime (millis)
	 * @return
	 * @throws ProviderException
	 */
	DBInterval[] getSlotsByTimeRange(byte[] certId, byte[] region, long start, long end)
			throws ProviderException;

	void save(DBInterval[] slots) throws ProviderException;

	int activate(byte[] requestHash) throws ProviderException;

	// void remove(byte[] certId, byte[] region) throws ProviderException;

}
