package de.fraunhofer.sit.c2x.pki.ca.provider.interfaces;

import java.io.IOException;

import org.bouncycastle.crypto.params.ECPrivateKeyParameters;

import de.fraunhofer.sit.c2x.pki.ca.core.interfaces.Service;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.Keystore;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public interface KeystoreProvider extends Service {

	public static enum KeyType {
		SIGNING_KEY, ENCRYPTION_KEY, CRL_SIGNING_KEY;
	}

	ECPrivateKeyParameters getKey(byte[] certid, KeyType type) throws IOException;

	long addKeystore(Keystore keystore);

	void linkCaCertificate(long id, byte[] certid);

	boolean removeKeystore(long id);

	/**
	 * Checks whether the id is linked to a temporary ca certificate slot
	 * 
	 * @param id
	 *            of the keystore
	 * @return true if the id is linked to a temporary ca certificate slot
	 */
	boolean hasTemporaryCaCertificate(long id);

}
