package de.fraunhofer.sit.c2x.pki.ca.provider.interfaces;

import de.fraunhofer.sit.c2x.pki.ca.core.interfaces.Service;
import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public interface CaInfoProvider<T> extends Service {

	public long getUptime();

	public T getCaCertificate() throws ProviderException;
	
	public T getCaCertificate(byte[] certId) throws ProviderException;
	
	public T[] getAll(int offset, int limit) throws ProviderException;
	
	public void setCaCertificate(T cert) throws ProviderException;

	void sortUp(byte[] certID) throws ProviderException;

	void sortDown(byte[] certID) throws ProviderException;

}
