package de.fraunhofer.sit.c2x.pki.ca.provider.entities;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = Constants.ISSUED_CERTIFICATE_INFO_LINK__TABLE)
/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class IssuedCertificateInfoLink implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public IssuedCertificateInfoLink() {
	}

	@Id
	@Column(name = Constants.ISSUED_CERTIFICATE_INFO__COL__ID, columnDefinition = "varbinary(16)", nullable = false)
	private byte[] certId;

	@Column(name = Constants.AUTHORIZED_DEVICES__COL__ID, nullable = false, columnDefinition = "binary(16)")
	private byte[] canonicalId;

	public byte[] getCertId() {
		return certId;
	}

	public void setCertId(byte[] certId) {
		this.certId = certId;
	}

	public byte[] getCanonicalId() {
		return canonicalId;
	}

	public void setCanonicalId(byte[] canonicalId) {
		this.canonicalId = canonicalId;
	}

}