package de.fraunhofer.sit.c2x.pki.ca.provider.entities;

import java.io.Serializable;
import java.util.Arrays;

import javax.persistence.Column;
import javax.persistence.Embeddable;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
@Embeddable
public class DBIntervalId implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@Column(name = Constants.SLOT__ID__CERT_ID, columnDefinition = "varbinary(8)")
	private byte[] certId;

	@Column(name = Constants.SLOT__ID__REGION, columnDefinition = "varbinary(32)", nullable = true)
	private byte[] region;

	@Column(name = Constants.SLOT__ID__START_TIME)
	private long startTime;

	@Column(name = Constants.SLOT__ID__END_TIME)
	private long endTime;

	public DBIntervalId(byte[] certId, byte[] region, long startTime, long endTime) {
		this.certId = certId;
		this.region = region;
		this.startTime = startTime;
		this.endTime = endTime;
	}

	public byte[] getCertId() {
		return certId;
	}

	public void setCertId(byte[] certId) {
		this.certId = certId;
	}

	public byte[] getRegion() {
		return region;
	}

	public void setRegion(byte[] region) {
		this.region = region;
	}

	public long getStartTime() {
		return startTime;
	}

	public void setStartTime(long startTime) {
		this.startTime = startTime;
	}

	public long getEndTime() {
		return endTime;
	}

	public void setEndTime(long endTime) {
		this.endTime = endTime;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + Arrays.hashCode(certId);
		result = prime * result + (int) (endTime ^ (endTime >>> 32));
		result = prime * result + (int) (startTime ^ (startTime >>> 32));
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		DBIntervalId other = (DBIntervalId) obj;
		if (!Arrays.equals(certId, other.certId))
			return false;
		if (endTime != other.endTime)
			return false;
		if (startTime != other.startTime)
			return false;
		return true;
	}


}
