package de.fraunhofer.sit.c2x.pki.ca.provider.entities;

import java.sql.Timestamp;
import java.util.Arrays;

import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name = Constants.CRL__TABLE)
/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class Crl {

	@EmbeddedId
	private CrlSeries crlSeries;

	@Column(name = Constants.CRL__COL__START_PERIOD, nullable = false)
	private Timestamp startPeriod;

	@Column(name = Constants.CRL__COL__NEXT_CRL, nullable = false)
	private Timestamp nextCrl;

	@Column(name = Constants.CRL__COL__CRL_BYTES, columnDefinition = "blob")
	private byte[] crl;
	
	public Crl() {
	}

	public CrlSeries getCrlSeries() {
		return crlSeries;
	}

	public void setCrlSeries(CrlSeries crlSeries) {
		this.crlSeries = crlSeries;
	}

	public Timestamp getStartPeriod() {
		return startPeriod;
	}

	public void setStartPeriod(Timestamp startPeriod) {
		this.startPeriod = startPeriod;
	}

	public Timestamp getNextCrl() {
		return nextCrl;
	}

	public void setNextCrl(Timestamp nextCrl) {
		this.nextCrl = nextCrl;
	}

	public byte[] getCrl() {
		return crl;
	}

	public void setCrl(byte[] crl) {
		this.crl = crl;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + Arrays.hashCode(crl);
		result = prime * result
				+ ((crlSeries == null) ? 0 : crlSeries.hashCode());
		result = prime * result + ((nextCrl == null) ? 0 : nextCrl.hashCode());
		result = prime * result
				+ ((startPeriod == null) ? 0 : startPeriod.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Crl other = (Crl) obj;
		if (!Arrays.equals(crl, other.crl))
			return false;
		if (crlSeries == null) {
			if (other.crlSeries != null)
				return false;
		} else if (!crlSeries.equals(other.crlSeries))
			return false;
		if (nextCrl == null) {
			if (other.nextCrl != null)
				return false;
		} else if (!nextCrl.equals(other.nextCrl))
			return false;
		if (startPeriod == null) {
			if (other.startPeriod != null)
				return false;
		} else if (!startPeriod.equals(other.startPeriod))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "Crl [crlSeries=" + crlSeries + ", startPeriod=" + startPeriod
				+ ", nextCrl=" + nextCrl + ", crl=" + Arrays.toString(crl)
				+ "]";
	};
	
	
	

}
