package de.fraunhofer.sit.c2x.pki.ca.module.webservice.service;

import java.net.InetSocketAddress;
import java.util.NoSuchElementException;

import javax.annotation.Resource;
import javax.inject.Inject;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.Action;
import javax.xml.ws.WebServiceContext;

import org.apache.log4j.Logger;
import org.eclipse.jetty.http.spi.JettyHttpsExchange;

import de.fraunhofer.sit.c2x.pki.ca.core.exceptions.HandlerException;
import de.fraunhofer.sit.c2x.pki.ca.core.logging.InjectLogger;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.handler.interfaces.CaCertificateRequestHandler;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.handler.interfaces.CaConfigRequestHandler;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.handler.interfaces.LtcRequestHandler;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.handler.interfaces.RequestErrorHandler;

@WebService(serviceName = "LtcaWeb", portName = "LtcaWebPort", targetNamespace = "http://http.ltca.pki.c2x.sit.fraunhofer.de/LtcaWebService")
@SOAPBinding(style = SOAPBinding.Style.RPC)
public class LtcaWebService implements de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.WebService {

	@Resource
	WebServiceContext wsContext;
	private InetSocketAddress remoteAddress;

	@InjectLogger
	private Logger logger;
	
	@Inject
	private RequestErrorHandler errorHandler;

	@Inject
	private CaCertificateRequestHandler cacertHandler;

	@Inject
	private LtcRequestHandler ltcRequestHandler;

	@Inject
	private CaConfigRequestHandler caConfigHandler;

	/**
	 * 
	 * @param longTermCertificateRequest
	 * @return returns byte[]
	 */
	@WebMethod
	@WebResult(name = "processLongTermCertificateRequestResponse", targetNamespace = "http://http.ltca.pki.c2x.sit.fraunhofer.de/", partName = "processLongTermCertificateRequestResponse")
	@Action(input = "http://http.ltca.pki.c2x.sit.fraunhofer.de/LtcaWebService/processLongTermCertificateRequestRequest", output = "http://http.ltca.pki.c2x.sit.fraunhofer.de/LtcaWebService/processLongTermCertificateRequestResponse")
	public byte[] processLongTermCertificateRequest(
			@WebParam(name = "longTermCertificateRequest", targetNamespace = "http://http.ltca.pki.c2x.sit.fraunhofer.de/", partName = "longTermCertificateRequest") byte[] longTermCertificateRequest) {

		try {
			if (logger.isDebugEnabled())
				logger.debug("START: handling of a Long Term Certificate Request from " + getRemoteAddress());
			
			byte[] responseBytes = ltcRequestHandler.handle(longTermCertificateRequest);
			
			if (logger.isDebugEnabled())
				logger.debug("END: handling of a Long Term Certificate Request from " + getRemoteAddress()
						+ " (successful)");
			return responseBytes;
		} catch (HandlerException e) {
			if (logger.isDebugEnabled()) {
				logger.debug("Error handling a Long Term Certificate Request from " + getRemoteAddress()
						+ ": " + e.getMessage());
				logger.debug("END: handling of a Long Term Certificate Request from " + getRemoteAddress()
						+ " (failed)");
			}
			return errorHandler.handle(longTermCertificateRequest, e);
		}
	}

	/**
	 * 
	 * @param ltcaCertificateRequest
	 * @return returns byte[]
	 */
	@WebMethod
	@WebResult(name = "processLTCACertificateRequestResponse", targetNamespace = "http://http.ltca.pki.c2x.sit.fraunhofer.de/", partName = "processLTCACertificateRequestResponse")
	@Action(input = "http://http.ltca.pki.c2x.sit.fraunhofer.de/LtcaWebService/processLTCACertificateRequestRequest", output = "http://http.ltca.pki.c2x.sit.fraunhofer.de/LtcaWebService/processLTCACertificateRequestResponse")
	public byte[] processLTCACertificateRequest(
			@WebParam(name = "LTCACertificateRequest", targetNamespace = "http://http.ltca.pki.c2x.sit.fraunhofer.de/", partName = "LTCACertificateRequest") byte[] ltcaCertificateRequest) {

		if (logger.isDebugEnabled())
			logger.debug("START: handling of a Certificate Download Request from " + getRemoteAddress());

		try {	
			byte[] responseBytes = cacertHandler.handle(ltcaCertificateRequest);
			
			if (logger.isDebugEnabled())
				logger.debug("END: handling of a Certificate Download Request from " + getRemoteAddress()
						+ " (successful)");
			return responseBytes;
		} catch (HandlerException e) {
			if (logger.isDebugEnabled()) {
				logger.debug("Error handling a Certificate Download Request from " + getRemoteAddress()
						+ ": " + e.getMessage());
				logger.debug("END: handling of a Certificate Download Request from " + getRemoteAddress()
						+ " (failed)");
			}
			return errorHandler.handle(ltcaCertificateRequest, e);
		}
	}

	/**
	 * 
	 * @param caConfigurationRequest
	 * @return returns byte[]
	 */
	@WebMethod
	@WebResult(name = "processCaConfigurationResponse", targetNamespace = "http://http.ltca.pki.c2x.sit.fraunhofer.de/", partName = "processCaConfigurationResponse")
	@Action(input = "http://http.ltca.pki.c2x.sit.fraunhofer.de/LtcaWebService/processCaConfigurationRequest", output = "http://http.ltca.pki.c2x.sit.fraunhofer.de/LtcaWebService/processCaConfigurationResponse")
	public byte[] processCaConfigurationRequest(
			@WebParam(name = "CaConfigurationRequest", targetNamespace = "http://http.ltca.pki.c2x.sit.fraunhofer.de/", partName = "CaConfigurationRequest") byte[] caConfigurationRequest) {
		if (logger.isDebugEnabled())
			logger.debug("START: handling of a CA Configuration Request from " + getRemoteAddress());

		try {
			byte[] responseBytes =caConfigHandler.handle(caConfigurationRequest);

			if (logger.isDebugEnabled())
				logger.debug("END: handling of a Certificate Download Request from " + getRemoteAddress()
						+ " (successful)");
			return responseBytes;
		} catch (HandlerException e) {
			if (logger.isDebugEnabled()) {
				logger.debug("Error handling a CA Configuration Request from " + getRemoteAddress() + ": "
						+ e.getMessage());
				logger.debug("END: handling of a CA Configuration Request from " + getRemoteAddress()
						+ " (failed)");
			}
			return errorHandler.handle(caConfigurationRequest, e);
		}
	}

	private InetSocketAddress getRemoteAddress() {
		if (remoteAddress != null) {
			return remoteAddress;
		} else {
			Object o = wsContext.getMessageContext().get("com.sun.xml.internal.ws.http.exchange");
			if (o == null || !o.getClass().equals(JettyHttpsExchange.class)) {
				throw new NoSuchElementException("No http exchange found to get remote IP address");
			}
			JettyHttpsExchange exchange = (JettyHttpsExchange) o;
			remoteAddress = exchange.getRemoteAddress();
			return remoteAddress;
		}
	}

	@Override
	public String getPath() {
		return "/LtcaWebService";
	}

}
