
package de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;

import de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes.Coordinates;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes.EncryptionParameters;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes.GeographicRegion;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes.IdentifiedRegion;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes.ItsStationRegistrationRequest;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes.ItsStationRegistrationRequestData;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes.ItsStationRegistrationResponse;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes.PsidSspPriority;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes.Region;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes.RequestError;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes.Time;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes.ValidityRestriction;


/**
 * This object contains factory methods for each 
 * Java content interface and Java element interface 
 * generated in the de.fraunhofer.sit.c2x.pki.ltca.http package. 
 * <p>An ObjectFactory allows you to programatically 
 * construct new instances of the Java representation 
 * for XML content. The Java representation of XML 
 * content can consist of schema derived interfaces 
 * and classes representing the binding of schema 
 * type definitions, element declarations and model 
 * groups.  Factory methods for each of these are 
 * provided in this class.
 * 
 */
@XmlRegistry
public class ObjectFactory {

    private final static QName _ProcessLongTermCertificateRequestResponse_QNAME = new QName("http://http.ltca.pki.c2x.sit.fraunhofer.de/", "processLongTermCertificateRequestResponse");
    private final static QName _ProcessAuthorizationValidationRequestResponse_QNAME = new QName("http://http.ltca.pki.c2x.sit.fraunhofer.de/", "processAuthorizationValidationRequestResponse");
    private final static QName _AuthorizationValidationResponseAck_QNAME = new QName("http://http.ltca.pki.c2x.sit.fraunhofer.de/", "authorizationValidationResponseAck");
    private final static QName _ItsStationRegistrationRequest_QNAME = new QName("http://http.ltca.pki.c2x.sit.fraunhofer.de/", "itsStationRegistrationRequest");
    private final static QName _LTCACertificateRequest_QNAME = new QName("http://http.ltca.pki.c2x.sit.fraunhofer.de/", "LTCACertificateRequest");
    private final static QName _LongTermCertificateRequest_QNAME = new QName("http://http.ltca.pki.c2x.sit.fraunhofer.de/", "longTermCertificateRequest");
    private final static QName _ProcessLTCACertificateRequestResponse_QNAME = new QName("http://http.ltca.pki.c2x.sit.fraunhofer.de/", "processLTCACertificateRequestResponse");
    private final static QName _ProcessItsStationRegistrationRequestResponse_QNAME = new QName("http://http.ltca.pki.c2x.sit.fraunhofer.de/", "processItsStationRegistrationRequestResponse");
    private final static QName _AuthorizationValidationRequest_QNAME = new QName("http://http.ltca.pki.c2x.sit.fraunhofer.de/", "authorizationValidationRequest");

    /**
     * Create a new ObjectFactory that can be used to create new instances of schema derived classes for package: de.fraunhofer.sit.c2x.pki.ltca.http
     * 
     */
    public ObjectFactory() {
    }

    /**
     * Create an instance of {@link AuthorizationValidationRequest }
     * 
     */
    public AuthorizationValidationRequest createAuthorizationValidationRequest() {
        return new AuthorizationValidationRequest();
    }

    /**
     * Create an instance of {@link ItsStationRegistrationResponse }
     * 
     */
    public ItsStationRegistrationResponse createItsStationRegistrationResponse() {
        return new ItsStationRegistrationResponse();
    }

    /**
     * Create an instance of {@link AuthorizationValidationResponse }
     * 
     */
    public AuthorizationValidationResponse createAuthorizationValidationResponse() {
        return new AuthorizationValidationResponse();
    }

    /**
     * Create an instance of {@link ItsStationRegistrationRequest }
     * 
     */
    public ItsStationRegistrationRequest createItsStationRegistrationRequest() {
        return new ItsStationRegistrationRequest();
    }

    /**
     * Create an instance of {@link AuthorizationValidationResponseAck }
     * 
     */
    public AuthorizationValidationResponseAck createAuthorizationValidationResponseAck() {
        return new AuthorizationValidationResponseAck();
    }

    /**
     * Create an instance of {@link AuthorizationValidationResponseData }
     * 
     */
    public AuthorizationValidationResponseData createAuthorizationValidationResponseData() {
        return new AuthorizationValidationResponseData();
    }

    /**
     * Create an instance of {@link Region }
     * 
     */
    public Region createRegion() {
        return new Region();
    }

    /**
     * Create an instance of {@link ItsStationRegistrationRequestData }
     * 
     */
    public ItsStationRegistrationRequestData createItsStationRegistrationRequestData() {
        return new ItsStationRegistrationRequestData();
    }

    /**
     * Create an instance of {@link EncryptionParameters }
     * 
     */
    public EncryptionParameters createEncryptionParameters(byte[] nonce, int symmAlgorithm) {
        return new EncryptionParameters(nonce, symmAlgorithm);
    }
    
    public EncryptionParameters createEncryptionParameters() {
        return new EncryptionParameters();
    }

    /**
     * Create an instance of {@link RecipientInfo }
     * 
     */
    public RecipientInfo createRecipientInfo() {
        return new RecipientInfo();
    }

    /**
     * Create an instance of {@link IdentifiedRegion }
     * 
     */
    public IdentifiedRegion createIdentifiedRegion() {
        return new IdentifiedRegion();
    }

    /**
     * Create an instance of {@link EcdsaSignature }
     * 
     */
    public EcdsaSignature createEcdsaSignature() {
        return new EcdsaSignature();
    }

    /**
     * Create an instance of {@link ApprovedCertificates }
     * 
     */
    public ApprovedCertificates createApprovedCertificates() {
        return new ApprovedCertificates();
    }

    /**
     * Create an instance of {@link EccPublicKey }
     * 
     */
    public EccPublicKey createEccPublicKey() {
        return new EccPublicKey();
    }

    /**
     * Create an instance of {@link Time }
     * 
     */
    public Time createTime() {
        return new Time();
    }

    /**
     * Create an instance of {@link ValidityRestriction }
     * 
     */
    public ValidityRestriction createValidityRestriction() {
        return new ValidityRestriction();
    }

    /**
     * Create an instance of {@link PsidSspPriority }
     * 
     */
    public PsidSspPriority createPsidSspPriority() {
        return new PsidSspPriority();
    }

    /**
     * Create an instance of {@link RequestSignature }
     * 
     */
    public RequestSignature createRequestSignature() {
        return new RequestSignature();
    }

    /**
     * Create an instance of {@link GeographicRegion }
     * 
     */
    public GeographicRegion createGeographicRegion() {
        return new GeographicRegion();
    }

    /**
     * Create an instance of {@link Coordinates }
     * 
     */
    public Coordinates createCoordinates() {
        return new Coordinates();
    }

    /**
     * Create an instance of {@link RequestError }
     * 
     */
    public RequestError createRequestError() {
        return new RequestError();
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link byte[]}{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://http.ltca.pki.c2x.sit.fraunhofer.de/", name = "processLongTermCertificateRequestResponse")
    public JAXBElement<byte[]> createProcessLongTermCertificateRequestResponse(byte[] value) {
        return new JAXBElement<byte[]>(_ProcessLongTermCertificateRequestResponse_QNAME, byte[].class, null, ((byte[]) value));
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link AuthorizationValidationResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://http.ltca.pki.c2x.sit.fraunhofer.de/", name = "processAuthorizationValidationRequestResponse")
    public JAXBElement<AuthorizationValidationResponse> createProcessAuthorizationValidationRequestResponse(AuthorizationValidationResponse value) {
        return new JAXBElement<AuthorizationValidationResponse>(_ProcessAuthorizationValidationRequestResponse_QNAME, AuthorizationValidationResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link AuthorizationValidationResponseAck }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://http.ltca.pki.c2x.sit.fraunhofer.de/", name = "authorizationValidationResponseAck")
    public JAXBElement<AuthorizationValidationResponseAck> createAuthorizationValidationResponseAck(AuthorizationValidationResponseAck value) {
        return new JAXBElement<AuthorizationValidationResponseAck>(_AuthorizationValidationResponseAck_QNAME, AuthorizationValidationResponseAck.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link ItsStationRegistrationRequest }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://http.ltca.pki.c2x.sit.fraunhofer.de/", name = "itsStationRegistrationRequest")
    public JAXBElement<ItsStationRegistrationRequest> createItsStationRegistrationRequest(ItsStationRegistrationRequest value) {
        return new JAXBElement<ItsStationRegistrationRequest>(_ItsStationRegistrationRequest_QNAME, ItsStationRegistrationRequest.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link byte[]}{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://http.ltca.pki.c2x.sit.fraunhofer.de/", name = "LTCACertificateRequest")
    public JAXBElement<byte[]> createLTCACertificateRequest(byte[] value) {
        return new JAXBElement<byte[]>(_LTCACertificateRequest_QNAME, byte[].class, null, ((byte[]) value));
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link byte[]}{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://http.ltca.pki.c2x.sit.fraunhofer.de/", name = "longTermCertificateRequest")
    public JAXBElement<byte[]> createLongTermCertificateRequest(byte[] value) {
        return new JAXBElement<byte[]>(_LongTermCertificateRequest_QNAME, byte[].class, null, ((byte[]) value));
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link byte[]}{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://http.ltca.pki.c2x.sit.fraunhofer.de/", name = "processLTCACertificateRequestResponse")
    public JAXBElement<byte[]> createProcessLTCACertificateRequestResponse(byte[] value) {
        return new JAXBElement<byte[]>(_ProcessLTCACertificateRequestResponse_QNAME, byte[].class, null, ((byte[]) value));
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link ItsStationRegistrationResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://http.ltca.pki.c2x.sit.fraunhofer.de/", name = "processItsStationRegistrationRequestResponse")
    public JAXBElement<ItsStationRegistrationResponse> createProcessItsStationRegistrationRequestResponse(ItsStationRegistrationResponse value) {
        return new JAXBElement<ItsStationRegistrationResponse>(_ProcessItsStationRegistrationRequestResponse_QNAME, ItsStationRegistrationResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link AuthorizationValidationRequest }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://http.ltca.pki.c2x.sit.fraunhofer.de/", name = "authorizationValidationRequest")
    public JAXBElement<AuthorizationValidationRequest> createAuthorizationValidationRequest(AuthorizationValidationRequest value) {
        return new JAXBElement<AuthorizationValidationRequest>(_AuthorizationValidationRequest_QNAME, AuthorizationValidationRequest.class, null, value);
    }

}
