package de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets.interfaces;

import java.math.BigInteger;
import java.util.List;

import de.fraunhofer.sit.c2x.pki.ca.certificates.datacontainers.GeographicRegionDataContainer;
import de.fraunhofer.sit.c2x.pki.ca.certificates.datacontainers.PsidSspPriorityDataContainer;
import de.fraunhofer.sit.c2x.pki.ca.core.exceptions.HandlerException;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes.ItsStationRegistrationRequest;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.Authenticator;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.PublicKey;

public interface ItsStationRegistrationHandler {

	public boolean handleItsStationRegistration(byte[] canonicalId, PublicKey publicKey, byte[] assuranceLevel,
			List<PsidSspPriorityDataContainer> permissions, GeographicRegionDataContainer region, String httpUserId)
			throws HandlerException;
	
	public BigInteger handleItsStationRegistration(ItsStationRegistrationRequest in, Authenticator authenticator) throws HandlerException;
}
