package de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.SessionAuthentication;

import com.google.inject.Inject;

import de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.HtmlProvider;

public class UserAuthentication extends AbstractServlet {
	private static final long serialVersionUID = 1L;

	public static final String URL = "/login";
	public static final String TITLE = "User Authentication";

	private String title = TITLE;

	private String url = URL;

	@Inject
	private LoginService loginService;

	@Inject
	public UserAuthentication(HtmlProvider htmlProvider) {
		super(htmlProvider);
	}

	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException,
			IOException {
		doGet(req, resp);
	}

	@Override
	public String getUrl() {
		return url;
	}

	@Override
	public String getTitle() {
		return title;
	}

	@Override
	protected String contentHtml(HttpServletRequest req, HttpServletResponse resp) {

		SessionAuthentication user = (SessionAuthentication) req.getSession().getAttribute(
				SessionAuthentication.__J_AUTHENTICATED);

		if (user != null && req.getParameter("logout") != null && req.getParameter("logout").length() > 0) {

			// Logout user
			loginService.logout(user.getUserIdentity());
			req.getSession().removeAttribute(SessionAuthentication.__J_AUTHENTICATED);
			//if(logger.isDebugEnabled()) logger.debug("USER: User "+user.getUserIdentity().getUserPrincipal().getName().toString()+" logged out manually!");

		}

		StringBuilder sb = new StringBuilder();
		if (req.getParameter("error") != null && req.getParameter("error").length() > 0)
			sb.append("<div id=\"errorbox\">Login failed</div>");

		sb.append("<h2>Authentication required</h2>\n");
		sb.append("<form action=\"/j_security_check\" method=\"post\">\n");
		sb.append("<input id=\"destinationUrl\" name=\"destinationUrl\" type=\"hidden\" value=\"");
		sb.append((req.getParameter("error") != null && req.getParameter("error").length() > 0) ? req
				.getParameter("destinationUrl") : "");
		sb.append("\" />\n");
		sb.append("<table>\n");
		sb.append("<tr><td>User:</td><td><input id=\"user\" name=\"j_username\" type=\"text\" value=\"\" style=\"width:400px\" maxlength=\"100\" /></td></tr>\n");
		sb.append("<tr><td>Password:</td><td><input id=\"password\" name=\"j_password\" type=\"password\" value=\"\" style=\"width:400px\" maxlength=\"20\" /></td></tr>\n");
		sb.append("<tr><td></td><td><input type=\"submit\" value=\"Login\" /></td></tr>\n");
		sb.append("</table>\n" + "</form>\n");

		return sb.toString();
	}

	@Override
	public boolean isProtected() {
		return true;
	}

	@Override
	public String[] getAllowedRoles() {
		return new String[] { UserRole.ADMINISTRATOR.toString(), UserRole.REGISTRATION_USER.toString(),
				UserRole.DEVELOPER.toString(), UserRole.MAINTAINER.toString(), UserRole.USER.toString() };
	}
	
	@Override
	public Category getCategory() {
		return Category.NO_CATEGORY;
	}
}
