package de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

import com.google.inject.Inject;

import de.fraunhofer.sit.c2x.pki.ca.core.logging.InjectLogger;
import de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.HtmlProvider;
import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.AuthorizedDeviceProvider;

/**
 * 
 * @author Norbert Bissmeyer (norbert.bissmeyer@sit.fraunhofer.de)
 * 
 */
public class ItsStationRevocationServlet extends AbstractServlet {

	private static final long serialVersionUID = 1L;
	protected static final String URL = "/revItsS";
	protected static final String TITLE = "Deactivate registered ITS-S";
	public static final String DATE_PATTERN_LOG = "yyyy-MM-dd HH:mm:ss";

	@InjectLogger
	private Logger logger;
	private AuthorizedDeviceProvider authorizedDeviceProvider;

	@Inject
	public ItsStationRevocationServlet(HtmlProvider htmlProvider,
			AuthorizedDeviceProvider authorizedDeviceProvider) {
		super(htmlProvider);
		this.authorizedDeviceProvider = authorizedDeviceProvider;
	}

	@Override
	public String getUrl() {
		return URL;
	}

	@Override
	public String getTitle() {
		return TITLE;
	}

	@Override
	protected String contentHtml(HttpServletRequest req, HttpServletResponse resp) {
		String userInfo = "";
		StringBuilder sb = new StringBuilder();

		// get moduleId/revId from GET variable
		byte[] deactivationIdBytes = new byte[0];
		String deactivationId = null;

		if (req.getParameter("deactivationId") != null && req.getParameter("deactivationId").length() > 0) {
			deactivationId = req.getParameter("deactivationId");
			deactivationId = deactivationId.trim();
			if (deactivationId.length() > 0) {
				try {
					deactivationIdBytes = Hex.decodeHex(deactivationId.toCharArray());
					if (deactivationIdBytes.length != 16) {
						deactivationIdBytes = new byte[0]; // reset
						throw new Exception("The given canonical ID (" + deactivationId + ") is not a valid ID!");
					}
				} catch (DecoderException e1) {
					logger.warn("Unable to decode hex values of authorized device ID " + deactivationId, e1);
					userInfo = "<div id=\"errorbox\">Unable to decode hex values of authorized device ID "
							+ deactivationId + "</div>";
				} catch (Exception e2) {
					logger.warn(e2.getMessage());
					userInfo = "<div id=\"errorbox\">" + e2.getMessage() + "</div>";
				}
			}
		}

		// Prepare the form
		sb.append("<form name=\"certForm\" action=\"\" onsubmit=\"return askBeforeDelete('Do you really want deactivate the ITS station?');\" method=\"get\">Deactivate ITS-S with canonical ID encoded as HEX string: ");

		if (req.getParameter("deactivate") == null) {
			// This is not a command to deactivate or delete an ITS-S

			if (deactivationIdBytes.length == 16) {
				// possibly valid module id available -> insert that id in the
				// form as the suggested value
				sb.append("<input type=\"hidden\" name=\"deactivate\" value=\"true\"/>\n<input type=\"text\" id=\"deactivationId\" name=\"deactivationId\" value=\""
						+ deactivationId
						+ "\" maxlength=\"32\" style=\"width:300px;\" />&nbsp;<input type=\"submit\" value=\"Deactivate\" /></form>");
			} else {
				sb.append("<input type=\"hidden\" name=\"deactivate\" value=\"true\"/>\n<input type=\"text\" id=\"deactivationId\" name=\"deactivationId\" value=\"\" maxlength=\"32\" style=\"width:300px;\" />&nbsp;<input type=\"submit\" value=\"Deactivate\" /></form>");
			}

		} else {

			boolean successfullyDeactivated = false;
			try {
				successfullyDeactivated = authorizedDeviceProvider.deactivateDevice(deactivationIdBytes);
				logger.debug("Device successfully deactivated!");
			} catch (ProviderException e) {
				logger.warn(e.getMessage());

			}
			sb.append("<input type=\"hidden\" name=\"deactivate\" value=\"true\"/>\n<input type=\"text\" id=\"moduleId\" name=\"moduleId\" value=\"\" maxlength=\"32\" style=\"width:300px;\" />&nbsp;<input type=\"submit\" value=\"Deactivate\" />");
			if (successfullyDeactivated)
				sb.append("<div id=\"ackbox\">Device \"" + deactivationId + "\" successfully deactivated.</div>");
			sb.append("</form>\n");
		}

		if (!userInfo.isEmpty()) {
			sb.append(userInfo);
		}
		/*
		 * try { if (moduleIDBytes.length == 16) { AuthorizedDevice
		 * registeredItsS = authorizedDeviceProvider.get(moduleIDBytes); if
		 * (registeredItsS != null) { registeredItsSs = new AuthorizedDevice[1];
		 * registeredItsSs[0] = registeredItsS; } else { userInfo =
		 * "<div id=\"errorbox\">Authorized device with ID " +
		 * req.getParameter("moduleId") + " not found in DB</div>"; } } else {
		 * registeredItsSs = authorizedDeviceProvider.getAll(0, 20); } } catch
		 * (ProviderException e) { logger.warn(e); userInfo =
		 * "<div id=\"errorbox\">Unable to request authorized device info from DB</div>"
		 * ; } if (!userInfo.isEmpty()) { sb.append("<br/><br/>" + userInfo); }
		 * else { // output list of cert infos sb.append("<table>\n"); for
		 * (AuthorizedDevice info : registeredItsSs) {
		 * sb.append("<tr><form action=\"" + ItsStationRegistrationServlet.URL +
		 * "\" method=\"get\">\n<td style=\"width:350px;\"><ul><li>CanonicalId: "
		 * + Hex.encodeHexString(info.getCanonicalId()) + "</li>\n");
		 * sb.append("<li>Creation time: " +
		 * formatedDate(info.getCreationTime()) + "</li>\n");
		 * if(info.getDeactivated() == 0){ sb.append("<li>Active: true</li>\n");
		 * } else { sb.append("<li>Active: false</li>\n"); }
		 * sb.append("</ul></td><td><input type=\"hidden\" name=\"deactivationId\" value=\""
		 * +Hex.encodeHexString(info.getCanonicalId())+
		 * "\"/><input type=\"submit\" value=\"Revoke\" /></td>\n</form>\n</tr>\n"
		 * ); } sb.append("</table>\n"); }
		 */
		return sb.toString();
	}

	@Override
	public boolean isProtected() {
		return true;
	}

	@Override
	public String[] getAllowedRoles() {
		return new String[] { UserRole.ADMINISTRATOR.toString(), UserRole.REGISTRATION_USER.toString(),
				UserRole.DEVELOPER.toString(), UserRole.MAINTAINER.toString() };
	}

	@Override
	public Category getCategory() {
		return Category.ITS_S;
	}
}
