package de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;

import com.google.inject.Inject;

import de.fraunhofer.sit.c2x.pki.ca.core.logging.InjectLogger;
import de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.HtmlProvider;
import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.IssuedCertificateInfo;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.IssuedCertsInfoProvider;

public class IssuedLongTermCertificatesServlet extends IssuedCertificatesServlet {
	private static final long serialVersionUID = 1L;
	protected static final String URL = "/ltcert";
	protected static final String TITLE = "Search issued Long-term certs";
	@InjectLogger
	private Logger logger;

	@Inject
	public IssuedLongTermCertificatesServlet(HtmlProvider htmlProvider,
			IssuedCertsInfoProvider<IssuedCertificateInfo> issuedCertsInfoProvider) {
		super(htmlProvider, issuedCertsInfoProvider);
	}

	@Override
	protected String contentHtml(HttpServletRequest req, HttpServletResponse resp) {
		String userInfo = "";
		StringBuilder sb = new StringBuilder();
		sb.append("<form name=\"certForm\" action=\"\" method=\"get\">Search certificate with certificate ID encoded as HEX string: ");
		sb.append("<input type=\"text\" id=\"cert\" name=\"cert\" value=\"\" maxlength=\"20\" style=\"width:200px;\" />&nbsp;<input type=\"submit\" value=\"Find\" /></form>");
		IssuedCertificateInfo[] issuedCerts = new IssuedCertificateInfo[0];

		// get certID8 from GET variable
		byte[] certIDBytes = new byte[0];
		if (req.getParameter("cert") != null && req.getParameter("cert").length() > 0) {
			String certID = req.getParameter("cert");
			certID = certID.trim();
			if (certID.length() > 0) {
				try {
					certIDBytes = Hex.decodeHex(certID.toCharArray());
				} catch (DecoderException e) {
					logger.warn("Unable to decode hex values of cert ID " + certID, e);
					userInfo = "<div id=\"errorbox\">Unable to decode hex values of cert ID " + certID
							+ "</div>";
				}
			}
		}

		try {
			if (certIDBytes.length >= 8) {
				issuedCerts = new IssuedCertificateInfo[1];
				IssuedCertificateInfo issuedCert = super.issuedCertsInfoProvider
						.getIssuedCertificate(certIDBytes);
				issuedCerts[0] = issuedCert;
			}
		} catch (ProviderException e) {
			logger.warn(e);
			userInfo = "<div id=\"errorbox\">Unable to get certificate from DB</div>";
		}
		if (userInfo != "") {
			sb.append("<br/><br/>" + userInfo);
		} else {
			// output list of cert infos
			sb.append("<table>\n");
			for (IssuedCertificateInfo info : issuedCerts) {
				sb.append("<tr><td style=\"width:450px;\"><ul><li>CertId: " + Hex.encodeHexString(info.getCertId()) + "</li>\n");
				if (info.getSubjectName() != null && info.getSubjectName().isEmpty() == false)
					sb.append("<li>Name: "
							+ StringEscapeUtils.escapeHtml4(info.getSubjectName()).replaceAll(
									"[^a-zA-Z0-9]+", "") + "</li>\n");
				sb.append("<li>Creation time: " + super.formatedDate(info.getCreationTime()) + "</li>\n");
				sb.append("<li>Expiration time: " + super.formatedDate(info.getExpirationTime()) + "</li>\n");
				// sb.append("<li>Signer CertId8: " + info.getSignerCertId +
				// "</li>\n");
				sb.append("</ul></td><td><form action=\"" + PPEServlet.URL
						+ "\" method=\"get\"><input type=\"hidden\" name=\"cert\" value=\""
						+ Hex.encodeHexString(info.getCertId())
						+ "\"/><input type=\"submit\" value=\"Show pseudonym intervals\" />\n");
				sb.append("</form></td></tr>\n");
			}
			sb.append("</table>\n");
		}

		return sb.toString();
	}

	@Override
	public String getUrl() {
		return URL;
	}

	@Override
	public String getTitle() {
		return TITLE;
	}

	@Override
	public Category getCategory() {
		return Category.LTC;
	}
}
