package de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets;

import java.io.IOException;

import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringEscapeUtils;

import de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.HtmlProvider;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.Configuration;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.ConfigProvider;

/**
 * A simple servlet that outputs the content of the configuration stored in the
 * DB
 * 
 * @author Norbert Bissmeyer (norbert.bissmeyer@sit.fraunhofer.de)
 * 
 */
public class ConfigurationServlet extends AbstractServlet {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public static final String URL = "/config";
	public static final String TITLE = "Configuration";
	public static final String DATE_PATTERN_LOG = "yyyy-MM-dd HH:mm:ss,SSS";

	public final ConfigProvider configProvider;

	@Inject
	public ConfigurationServlet(HtmlProvider htmlProvider, ConfigProvider configProvider) {
		super(htmlProvider);
		this.configProvider = configProvider;
	}

	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException,
			IOException {
		String userInfo = "";
		boolean updateFound = false;
		// check permission of web user

		int i = 0;
		for (Configuration conf : configProvider.getAll()) {
			if (req.getParameter(conf.getId()) != null && req.getParameter(conf.getId()).length() > 0) {
				// compare new value with old value. Only in case of
				// changes the update is written into the DB
				if (conf.getValue().equals(req.getParameter(conf.getId())) == false) {
					// do update of DB
					configProvider.save(new Configuration(conf.getId(), req.getParameter(conf.getId())));
					updateFound = true;
					i++;
				}
			}
		}
		if (updateFound)
			userInfo = "<div id=\"ackbox\">" + i + " values updated in database</div>";

		response.sendRedirect(URL + "?userInfo=" + userInfo);
	}

	@Override
	public String getUrl() {
		return URL;
	}

	@Override
	public String getTitle() {
		return TITLE;
	}

	@Override
	protected String contentHtml(HttpServletRequest req, HttpServletResponse resp) {

		StringBuilder sb = new StringBuilder();
		String userInfo = "";

		if (req.getParameter("userInfo") != null && req.getParameter("userInfo").length() > 0) {
			userInfo = req.getParameter("userInfo");
		}

		if (userInfo != "")
			sb.append(userInfo);

		sb.append("<form name=\"configForm\" action=\"\" method=\"post\">\n");
		sb.append("<table>\n");
		for (Configuration conf : configProvider.getAll()) {
			sb.append("<tr><td>" + conf.getId() + ":</td><td><input id=\"" + conf.getId() + "\" name=\""
					+ conf.getId());
			// content of password fields is not shown in clear text
			if (conf.getId().contains("assword"))
				sb.append("\" type=\"password\" ");
			else
				sb.append("\" type=\"text\" ");
			sb.append("value=\"" + StringEscapeUtils.escapeHtml4(conf.getValue()));
			sb.append("\" style=\"width:400px\" maxlength=\"200\" /></td></tr>\n");
		}
		sb.append("<tr><td></td><td><br /><input type=\"submit\" value=\"Update\" /></td></tr>\n"
				+ "</table>\n");
		sb.append("</form>\n");

		return sb.toString();
	}

	@Override
	public boolean isProtected() {
		return true;
	}

	@Override
	public String[] getAllowedRoles() {
		return new String[] { UserRole.ADMINISTRATOR.toString()};
	}
	
	@Override
	public Category getCategory() {
		return Category.SETUP;
	}
}
