package de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.inject.Inject;

import de.fraunhofer.sit.c2x.pki.ca.certificates.CertificateBuilder;
import de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.HtmlProvider;
import de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets.datatypes.CaCertificateWebHandlerResult;
import de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets.interfaces.CaCertificateWebHandler;

public class CaCertificateInstallationServlet extends AbstractServlet {

	public static final String URL = "/caCertificateInstallation";
	public static final String TITLE = "CA certificate installation";

	private String info;

	@Inject
	CaCertificateWebHandler caCertificateWebHandler;

	@Inject
	CertificateBuilder certificateBuilder;

	@Inject
	public CaCertificateInstallationServlet(HtmlProvider htmlProvider) {
		super(htmlProvider);
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@Override
	public String getUrl() {
		return URL;
	}

	@Override
	public String getTitle() {
		return TITLE;
	}

	@Override
	protected String contentHtml(HttpServletRequest req, HttpServletResponse resp) {

		StringBuilder sb = new StringBuilder();
		info = "";

		if (req.getParameter("idkID") == null && req.getParameter("caCertificateRequest") == null
				&& req.getParameter("caCertificateResponse") == null
				&& req.getParameter("caCertificateResponseData") == null) {
			// Initial Form

			sb.append("<form action=\"" + URL + "\" method=\"get\">\n");
			if (!info.isEmpty())
				sb.append(info);
			sb.append("<table>\n");
			sb.append("<tr><td></td><td><input type=\"submit\" name=\"caCertificateRequest\" value=\"Request new CA Certificate\" /></td></tr>\n");
			sb.append("<tr><td></td><td><input type=\"submit\" name=\"caCertificateResponse\" value=\"Insert Response\" /></td></tr>\n");
			sb.append("</table>\n" + "</form>\n");
		} else if (req.getParameter("caCertificateResponse") != null) {
			// Insertion of Response Data

			sb.append("<form action=\"" + URL + "\" method=\"get\">\n");
			if (!info.isEmpty())
				sb.append(info);
			sb.append("Please enter the CA certificate response of the Root CA.\n");
			sb.append("<table>\n");
			sb.append("<tr><td>Request Id:</td><td><input id=\"requestId\" name=\"requestId\" type=\"text\" value=\"\" style=\"width:400px\" /></td></tr>\n");
			sb.append("<tr><td>Certificate (hex-encoded):</td><td><textarea id=\"certificate\" name=\"certificate\" rows=\"5\" style=\"width:400px\"></textarea></td></tr>\n");
			sb.append("<tr><td></td><td><input type=\"submit\" name=\"caCertificateResponseData\" value=\"Submit\" /></td></tr>\n");
			sb.append("</table>\n" + "</form>\n");
		} else if (req.getParameter("caCertificateRequest") != null) {
			// Presentation of Request Data

			CaCertificateWebHandlerResult requestData = null;

			try {
				requestData = caCertificateWebHandler.prepareCaCertificateCreation();

			} catch (KeyStoreException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (NoSuchAlgorithmException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (CertificateException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			if (requestData != null) {
				sb.append("<form action=\"" + URL + "\" method=\"get\">\n");
				if (!info.isEmpty())
					sb.append(info);
				sb.append("<table>\n");
				sb.append("<tr>Please copy the following information and send it to the administrator of the responsible Root CA:</tr>\n");
				sb.append("<tr><td><hr/></td><td></td></tr>\n");
				sb.append("<tr><td>id:</td><td>" + requestData.getId() + "</td></tr>\n");
				sb.append("<tr><td>signingKeyX:</td><td>" + requestData.getSigningKeyX() + "</td></tr>\n");
				sb.append("<tr><td>signingKeyY:</td><td>" + requestData.getSigningKeyY() + "</td></tr>\n");
				sb.append("<tr><td>encryptionKeyX:</td><td>" + requestData.getEncryptionKeyX()
						+ "</td></tr>\n");
				sb.append("<tr><td>encryptionKeyY:</td><td>" + requestData.getEncryptionKeyY()
						+ "</td></tr>\n");
				sb.append("<tr><td>version:</td><td>" + requestData.getVersion() + "</td></tr>\n");
				sb.append("<tr><td>algorithm:</td><td>" + requestData.getAlgorithm() + "</td></tr>\n");
				sb.append("<tr><td>symmetricAlgorithm:</td><td>" + requestData.getSymmetricAlgorithm()
						+ "</td></tr>\n");
				sb.append("<tr><td>compression:</td><td>" + requestData.getCompression() + "</td></tr>\n");
				sb.append("<tr><td><hr/></td><td></td></tr>\n");
				sb.append("<tr><input type=\"submit\" name=\"caCertificateRequest\" value=\"Request another CA Certificate\" /></tr>\n");
				sb.append("<tr><input type=\"submit\" name=\"caCertificateResponse\" value=\"Insert Response\" /></tr>\n");
				sb.append("</table>\n" + "</form>\n");

			} else {
				sb.append("<form action=\"" + URL + "\" method=\"get\">\n");
				if (!info.isEmpty())
					sb.append(info);
				sb.append("<table>\n");
				sb.append("<tr>An error accured! Please inform the CA administrator!</tr>\n");
				sb.append("</table>\n" + "</form>\n");
			}
		} else if (req.getParameter("caCertificateResponseData") != null) {

			boolean choice = false;
			String errorInfo = "";

			if (req.getParameter("requestId") != null && req.getParameter("certificate") != null) {
				try {
					choice = caCertificateWebHandler.handleCaCertificateString(
							new Long(req.getParameter("requestId")), req.getParameter("certificate"));
				} catch (Exception e) {
					e.printStackTrace();
					errorInfo = e.getMessage();
				}

			}

			if (choice == true) {
				sb.append("<form action=\"" + URL + "\" method=\"get\">\n");
				if (!info.isEmpty())
					sb.append(info);
				sb.append("<table>\n");
				sb.append("<tr>Certificate successfully submitted!</tr>\n");
				sb.append("<tr><td><hr/></td><td></td></tr>\n");
				sb.append("<tr><input type=\"submit\" name=\"caCertificateRequest\" value=\"Request another CA Certificate\" /></tr>\n");
				sb.append("<tr><input type=\"submit\" name=\"caCertificateResponse\" value=\"Insert Response\" /></tr>\n");
				sb.append("</table>\n" + "</form>\n");
			} else {
				sb.append("<form action=\"" + URL + "\" method=\"get\">\n");
				if (!info.isEmpty())
					sb.append(info);
				sb.append("<table>\n");
				sb.append("<tr>An error accured: The submitted certificate could not be handled! "
						+ errorInfo + "</tr>\n");
				sb.append("<tr><td><hr/></td><td></td></tr>\n");
				sb.append("<tr><input type=\"submit\" name=\"caCertificateRequest\" value=\"Request another CA Certificate\" /></tr>\n");
				sb.append("<tr><input type=\"submit\" name=\"caCertificateResponse\" value=\"Insert Response\" /></tr>\n");
				sb.append("</table>\n" + "</form>\n");
			}
		}

		return sb.toString();
	}

	@Override
	public boolean isProtected() {
		return true;
	}

	@Override
	public String[] getAllowedRoles() {
		return new String[] { UserRole.ADMINISTRATOR.toString() };
	}
	
	@Override
	public Category getCategory() {
		return Category.SETUP;
	}
}
