package de.fraunhofer.sit.c2x.pki.ca.crypto.keystore;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

import org.bouncycastle.crypto.AsymmetricCipherKeyPair;

import de.fraunhofer.sit.c2x.pki.ca.provider.entities.Keystore;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class KeystoreAdapter extends Keystore {

	private final KeyStoreImpl keystore;

	public KeystoreAdapter(KeyStoreImpl keystore) {
		super();
		this.keystore = keystore;
	}

	/**
	 * 
	 * @param verificationKey
	 * @param encryptionKey
	 * @param passphrase
	 *            password of keystore
	 */
	public KeystoreAdapter(AsymmetricCipherKeyPair verificationKey,
			AsymmetricCipherKeyPair encryptionKey, String passphrase) {
		KeyStoreImpl tmp = null;
		try {
			tmp = new KeyStoreImpl(verificationKey, encryptionKey, passphrase);
		} catch (KeyStoreException | NoSuchAlgorithmException
				| CertificateException | IOException e) {
			e.printStackTrace();
		}
		this.keystore = tmp;
	}

	@Override
	public byte[] getKeystore() {
		return this.keystore.getKeyStoreBytes();
	}

}
