/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.crypto;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;

import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;


/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class KeyGenerator {

	public static KeyGenerator instance = null;

	public static final Provider BC = new BouncyCastleProvider();

	SecureRandom random = new SecureRandom();

	private KeyGenerator() {
		Security.addProvider(BC);
	}

	public static KeyGenerator getInstance() {

		if (instance == null)
			instance = new KeyGenerator();

		return instance;
	}

	public Key generateAesKey() {

		javax.crypto.KeyGenerator keyGen;
		try {
			keyGen = javax.crypto.KeyGenerator.getInstance("AES", BC);
			keyGen.init(128, new SecureRandom());
			return keyGen.generateKey();
		} catch (NoSuchAlgorithmException e) {
		}
		return null;
	}

	public AsymmetricCipherKeyPair generateECKeyPair(String spec) {

		ECKeyPairGenerator gen = new ECKeyPairGenerator();
		ECNamedCurveParameterSpec curveName = ECNamedCurveTable
				.getParameterSpec(spec);

		ECDomainParameters domain = new ECDomainParameters(
				curveName.getCurve(), curveName.getG(), curveName.getN(),
				curveName.getH(), curveName.getSeed());
		gen.init(new ECKeyGenerationParameters(domain, new SecureRandom()));

		AsymmetricCipherKeyPair keyPair = gen.generateKeyPair();
		return keyPair;
	}

	public AsymmetricCipherKeyPair generateCompressedECKeyPair(String spec) {
		AsymmetricCipherKeyPair keyPair = generateECKeyPair(spec);
		ECPublicKeyParameters publicKey = (ECPublicKeyParameters) keyPair
				.getPublic();

		ECPublicKeyParameters compressedPublicKey = CryptoUtils
				.compressECPublicKeyParameters(publicKey);

		AsymmetricCipherKeyPair newKeyPair = new AsymmetricCipherKeyPair(
				compressedPublicKey, keyPair.getPrivate());

		return newKeyPair;
	}

}
