package de.fraunhofer.sit.c2x.pki.ca.core.interfaces;

import java.io.DataOutputStream;
import java.io.IOException;
/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public interface WaveType {

	/**
	 * Write the type's data into the output stream. The written data has to be
	 * compliant with IEEE 1609.2 where applicable.
	 * 
	 * @param out
	 *            ; stream to write the data to
	 * @return number of bytes written to <code>out</code>
	 * @throws IOException
	 */
	public int writeData(DataOutputStream out) throws IOException;

}
