package de.fraunhofer.sit.c2x.pki.ca.core;

import de.fraunhofer.sit.c2x.pki.ca.core.Validate.Status.StatusType;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class Validate {

	static class Status {

		protected static enum StatusType {
			IS, IS_NOT;
		}

		protected final StatusType type;
		protected final String msg;

		public Status(StatusType type, String msg) {
			this.msg = msg;
			this.type = type;
		}

		public Status toggle() {
			return new Status(type == StatusType.IS ? StatusType.IS_NOT : StatusType.IS, msg);
		}
	}

	public static class Argument {
		private final Object o;
		private final String field;

		public Argument(Object o, String field) {
			this.o = o;
			this.field = field;
		}

		private Status is(Status status) {
			if (status.type != StatusType.IS) {
				throwException(status.msg);
			}
			return status;
		}

		private Status not(Status status) {
			if (status.type != StatusType.IS_NOT) {
				throwException(status.msg);
			}
			return status;
		}

		public void isNull() {
			is(nullValue());
		}

		public void isNotNull() {
			not(nullValue());
		}

		public void isInt() {
			is(integerValue());
		}
		
		public void isBetween(double arg1, double arg2) {
			is(betweenValue(arg1, arg2));
		}
		
		public void isNotBetween(double arg1, double arg2) {
			not(betweenValue(arg1, arg2));
		}

		private Status nullValue() {
			if (o == null) {
				return new Status(StatusType.IS, "Argument is null");
			} else {
				return new Status(StatusType.IS_NOT, "Argument is not null");
			}
		}

		private Status integerValue() {
			if (o != null && o instanceof Integer) {
				return new Status(StatusType.IS, "Argument is an integer");
			} else {
				return new Status(StatusType.IS_NOT, "Argument is not an integer");
			}
		}

		private Status betweenValue(double arg1, double arg2) {
			if (o != null && o instanceof Number && ((Number) o).doubleValue() >= arg1
					&& ((Number) o).doubleValue() <= arg2) {
				return new Status(StatusType.IS, "Argument is between "+arg1+" and "+arg2);
			} else {
				return new Status(StatusType.IS_NOT, "Argument is not between "+arg1+" and "+arg2);
			}
		}

		private void throwException(String msg) {
			StackTraceElement stack = Thread.currentThread().getStackTrace()[4];
			throw new IllegalArgumentException(String.format("[IllegalArgument in class:%s, line:%d]: " + msg
					+ " (<%s>)", stack.getClassName(), stack.getLineNumber(), field));
		}

	}

	public static Argument arg(Object o, String field) {
		return new Argument(o, field);
	}

}
