package de.fraunhofer.sit.c2x.pki.ca.certificates.datacontainers;

public class GeographicRegionDataContainer {
	// IdentifiedRegion
	protected String dictionary = null;
	protected Long regionIdentifier = null;
	protected Long localRegion = null;
	// CircularRegion
	protected Double centerLatitude = null;
	protected Double centerLongitude = null;
	protected Integer radius = null;
	// RectangularRegion
	protected Double[] rectangleNorthWestLatitudes = null;
	protected Double[] rectangleNorthWestLongitudes = null;
	protected Double[] rectangleSouthEastLatitudes = null;
	protected Double[] rectangleSouthEastLongitudes = null;
	// PolygonalRegion
	protected Double[] polygonalPointLatitudes = null;
	protected Double[] polygonalPointLongitudes = null;

	public GeographicRegionDataContainer(String dictionary, Long regionIdentifier, Long localRegion) {
		super();
		this.dictionary = dictionary;
		this.regionIdentifier = regionIdentifier;
		this.localRegion = localRegion;
	}

	public GeographicRegionDataContainer(Double centerLatitude, Double centerLongitude, Integer radius) {
		super();
		this.centerLatitude = centerLatitude;
		this.centerLongitude = centerLongitude;
		this.radius = radius;
	}

	public GeographicRegionDataContainer(Double[] northWestLatitudes, Double[] northWestLongitudes,
			Double[] southEastLatitudes, Double[] southEastLongitudes) {
		super();

		int length = northWestLatitudes.length;
		if (northWestLongitudes.length != length || southEastLatitudes.length != length
				|| southEastLongitudes.length != length)
			throw new IllegalArgumentException(
					"Length of latitude / longitude arrays for rectangles not equal");

		this.rectangleNorthWestLatitudes = northWestLatitudes;
		this.rectangleNorthWestLongitudes = northWestLongitudes;
		this.rectangleSouthEastLatitudes = southEastLatitudes;
		this.rectangleSouthEastLongitudes = southEastLongitudes;
	}

	public GeographicRegionDataContainer(Double[] polygonalPointLatitudes, Double[] polygonalPointLongitudes) {
		super();

		int length = polygonalPointLatitudes.length;
		if (polygonalPointLongitudes.length != length)
			throw new IllegalArgumentException("Length of latitude / longitude arrays for polygon not equal");

		this.polygonalPointLatitudes = polygonalPointLatitudes;
		this.polygonalPointLongitudes = polygonalPointLongitudes;
	}

	public String getDictionary() {
		return dictionary;
	}

	public void setDictionary(String dictionary) {
		this.dictionary = dictionary;
	}

	public Long getRegionIdentifier() {
		return regionIdentifier;
	}

	public void setRegionIdentifier(Long regionIdentifier) {
		this.regionIdentifier = regionIdentifier;
	}

	public Long getLocalRegion() {
		return localRegion;
	}

	public void setLocalRegion(Long localRegion) {
		this.localRegion = localRegion;
	}

	public Integer getRadius() {
		return radius;
	}

	public void setRadius(Integer radius) {
		this.radius = radius;
	}

	public Double getCenterLatitude() {
		return centerLatitude;
	}

	public void setCenterLatitude(Double centerLatitude) {
		this.centerLatitude = centerLatitude;
	}

	public Double getCenterLongitude() {
		return centerLongitude;
	}

	public void setCenterLongitude(Double centerLongitude) {
		this.centerLongitude = centerLongitude;
	}

	public Double[] getRectangleNorthWestLatitudes() {
		return rectangleNorthWestLatitudes;
	}

	public void setRectangleNorthWestLatitudes(Double[] rectangleNorthWestLatitudes) {
		this.rectangleNorthWestLatitudes = rectangleNorthWestLatitudes;
	}

	public Double[] getRectangleNorthWestLongitudes() {
		return rectangleNorthWestLongitudes;
	}

	public void setRectangleNorthWestLongitudes(Double[] rectangleNorthWestLongitudes) {
		this.rectangleNorthWestLongitudes = rectangleNorthWestLongitudes;
	}

	public Double[] getRectangleSouthEastLatitudes() {
		return rectangleSouthEastLatitudes;
	}

	public void setRectangleSouthEastLatitudes(Double[] rectangleSouthEastLatitudes) {
		this.rectangleSouthEastLatitudes = rectangleSouthEastLatitudes;
	}

	public Double[] getRectangleSouthEastLongitudes() {
		return rectangleSouthEastLongitudes;
	}

	public void setRectangleSouthEastLongitudes(Double[] rectangleSouthEastLongitudes) {
		this.rectangleSouthEastLongitudes = rectangleSouthEastLongitudes;
	}

	public Double[] getPolygonalPointLatitudes() {
		return polygonalPointLatitudes;
	}

	public void setPolygonalPointLatitudes(Double[] polygonalPointLatitudes) {
		this.polygonalPointLatitudes = polygonalPointLatitudes;
	}

	public Double[] getPolygonalPointLongitudes() {
		return polygonalPointLongitudes;
	}

	public void setPolygonalPointLongitudes(Double[] polygonalPointLongitudes) {
		this.polygonalPointLongitudes = polygonalPointLongitudes;
	}
}
