package de.fraunhofer.sit.c2x.pki.ca.certificates;

import java.util.ArrayList;

import org.apache.commons.codec.DecoderException;

import de.fraunhofer.sit.c2x.pki.ca.certificates.datacontainers.PsidSspPriorityDataContainer;

public class PsidUtils {

	public static ArrayList<PsidSspPriorityDataContainer> createNewPsidSet(){
		ArrayList<PsidSspPriorityDataContainer> out = new ArrayList<PsidSspPriorityDataContainer>();		
		return out;
	}
	
	public static void addRestrictionToPsidSet(ArrayList<PsidSspPriorityDataContainer> set, String psid,
			String serviceSpecificPermissions, String maxPriority) throws DecoderException {
		
		if(set == null || (psid == null && serviceSpecificPermissions == null && maxPriority == null)) return;
		
		PsidSspPriorityDataContainer data = new PsidSspPriorityDataContainer();
		
		if(maxPriority != null) data.setMaxPriority(new Integer(maxPriority));
		
		if(psid != null) data.setPsid(new Long(psid));
		
		if(serviceSpecificPermissions != null) data.setServiceSpecificPermissions(serviceSpecificPermissions);
		
		set.add(data);
	}
	
}
