package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.validator.time;

import de.fraunhofer.sit.c2x.pki.ca.validator.Validator;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.Time32;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.ValidityRestriction;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class MaxValidityTimeValidator implements Validator<ValidityRestriction[]> {

	public final static int MAX_VALIDITY = 2 * 31556925; // 2 years - 1 year = 31 556 925sec, see ETSI TS103097v0.13
															// seconds;

	@Override
	public boolean validate(ValidityRestriction[] object) {
		Time32[] time;
		try {
			time = TimeUtils.extractTime(object);

			return time[1].getTime32().get() - time[0].getTime32().get() <= MAX_VALIDITY;
		} catch (IllegalArgumentException e) {
			return false;
		}

	}

}
