package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils;

import java.util.HashMap;
import java.util.Map;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 * @param <KeyType>
 * @param <ValueType>
 */
public class BiDirectionalMap<KeyType, ValueType> {

	Map<KeyType, ValueType> keyMap;
	Map<ValueType, KeyType> valueMap;

	public BiDirectionalMap() {
		keyMap = new HashMap<>();
		valueMap = new HashMap<>();
	}

	public synchronized void put(KeyType key, ValueType value) {
		keyMap.put(key, value);
		valueMap.put(value, key);
	}

	public KeyType getKeyByValue(ValueType value) {
		return valueMap.get(value);
	}

	public ValueType getValueByKey(KeyType key) {
		return keyMap.get(key);
	}
}
