package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.provider;

import java.io.IOException;

import javax.inject.Inject;

import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.IssuedCertificateInfo;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.IssuedCertsInfoProvider;
import de.fraunhofer.sit.c2x.pki.ca.utils.WaveUtils;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.handler.adapter.CertificateAdapter;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.Certificate;

public class EtsiIssuedCertsInfoProvider implements
		IssuedCertsInfoProvider<Certificate> {

	@Inject
	private IssuedCertsInfoProvider<IssuedCertificateInfo> provider;

	@Override
	public void startService() {
		provider.startService();
	}

	@Override
	public void stopService() {
		provider.stopService();
	}

	@Override
	public String getName() {
		return provider.getName();
	}

	@Override
	public boolean isStarted() {
		return provider.isStarted();
	}

	@Override
	public Certificate[] getAll(int offset, int limit) throws ProviderException {

		IssuedCertificateInfo[] info = provider.getAll(offset, limit);
		Certificate[] certs = new Certificate[info.length];
		for (int i = 0; i < info.length; i++) {
			try {
				certs[i] = WaveUtils.getElementFromBytes(
						info[i].getCertificate(), Certificate.class);
			} catch (IOException e) {
				throw new ProviderException(e);
			}
		}
		return certs;
	}

	@Override
	public Certificate getIssuedCertificate(byte[] certId)
			throws ProviderException {
		IssuedCertificateInfo info = provider.getIssuedCertificate(certId);
		try {
			return WaveUtils.getElementFromBytes(info.getCertificate(),
					Certificate.class);
		} catch (IOException e) {
			return null;
		}
	}

	@Override
	public void save(Certificate info) throws ProviderException {

		IssuedCertificateInfo infos = new IssuedCertificateInfo();
		try {
			infos.setCertificate(new CertificateAdapter(info));
		} catch (IOException e) {
			throw new ProviderException(e);
		}

		provider.save(infos);
	}

}
