package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * Representation of Unit8 type: an unsigned, 8-bit integer.
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class UInt8 extends WaveElement {

	protected int data;

	public UInt8() {
		super();
	}

	public UInt8(int val) {

		set(val);
	}

	public UInt8(DataInputStream in) throws IOException {
		set(in);
	}

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.fraunhofer.sit.c2x.pki.ca.types.etsi.v0_0_4.impl.UInt8#get()
	 */
	public int get() {
		return this.data;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.fraunhofer.sit.c2x.pki.ca.types.etsi.v0_0_4.impl.UInt8#set(java.lang
	 * .Integer)
	 */
	public void set(int data) {
		if (data < 0 || data > 255) {
			throw new IllegalArgumentException(
					"Wrong input! Value shall be between 0 and 255");
		}
		this.data = data & 0x00FF;
	}

	protected void set(DataInputStream in) throws IOException {
		this.data = in.readByte() & 0xFF;
	}

	public int writeData(DataOutputStream out) throws IOException {
		out.write(this.data);
		return 1;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + data;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (getClass() != obj.getClass())
			return false;
		UInt8 other = (UInt8) obj;
		if (data != other.data)
			return false;
		return true;
	}

}
