package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;

import de.fraunhofer.sit.c2x.pki.ca.utils.ByteUtils;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class UInt64 extends WaveElement {

	private final byte[] unsignedBytes;

	public UInt64(BigInteger val) {

		if (val.signum() < 0 || val.bitLength() > 64)
			throw new IllegalArgumentException(
					"Wrong input! Value shall be between 0 and 2^64-1");

		unsignedBytes = ByteUtils.convertBigIntTo8ByteArray(val);
	}

	public UInt64(DataInputStream in) throws IOException {
		if (in == null)
			throw new IllegalArgumentException(
					"DataInputStream must not be null");

		byte[] bytes = new byte[8];
		in.readFully(bytes);
		unsignedBytes = bytes;
	}

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	public final BigInteger get() {
		return ByteUtils.convertByteArrayToBigInt(unsignedBytes);
	}

	public int writeData(DataOutputStream out) throws IOException {
		out.write(unsignedBytes);
		return 8;
	}
}
