package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class TwoDLocation extends WaveElement implements
		de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.TwoDLocation {
	private final static double TENTHS_OF_MICRODEGREE = (10 * 1000 * 1000);

	// ---- fields ----

	@Internal(order = 0)
	private SInt32 latitude;

	@Internal(order = 1)
	private SInt32 longitude;

	// ---- fields ----

	// ---- constructors ----

	public TwoDLocation() {
	}

	public TwoDLocation(double latitude, double longitude) {
		super();

		this.latitude = new SInt32(new Double(latitude * TENTHS_OF_MICRODEGREE).intValue());
		if (latitudeIsAvailable() == false)
			throw new IllegalArgumentException("Empty latitude value!");

		this.longitude = new SInt32(new Double(longitude * TENTHS_OF_MICRODEGREE).intValue());
		if (longitudeIsAvailable() == false)
			throw new IllegalArgumentException("Empty latitude value!");
	}
	
	public TwoDLocation(int latitude, int longitude) {
		super();

		this.latitude = new SInt32(latitude);
		if (latitudeIsAvailable() == false)
			throw new IllegalArgumentException("Empty latitude value!");

		this.longitude = new SInt32(longitude);
		if (longitudeIsAvailable() == false)
			throw new IllegalArgumentException("Empty latitude value!");
	}

	public TwoDLocation(DataInputStream in) throws IOException {
		latitude = new SInt32(in);
		if (latitudeIsAvailable() == false)
			throw new IllegalArgumentException("Empty latitude value!");

		longitude = new SInt32(in);
		if (longitudeIsAvailable() == false)
			throw new IllegalArgumentException("Empty latitude value!");
	}

	// ---- accept ----

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	// ---- getter ----

	public SInt32 getLatitudeInt() {
		return this.latitude;
	}

	public SInt32 getLongitudeInt() {
		return this.longitude;
	}

	// ---- setter ----

	public void setLatitude(SInt32 latitude) {
		this.latitude = latitude;
	}

	public void setLongitude(SInt32 longitude) {
		this.longitude = longitude;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		if (latitude == null || longitude == null)
			throw new IllegalStateException("args may not be null");
		int written = latitude.writeData(out);
		written += longitude.writeData(out);
		return written;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((latitude == null) ? 0 : latitude.hashCode());
		result = prime * result + ((longitude == null) ? 0 : longitude.hashCode());
		return result;
	}

	public boolean latitudeIsAvailable() {
		if (latitude == null || latitude.get() == 900000001) {
			return false;
		} else if (latitude.get() > 900000001 || latitude.get() < -900000000) {
			throw new IllegalArgumentException("Invalid latitude value!");
		} else
			return true;
	}

	public boolean longitudeIsAvailable() {
		if (longitude == null || longitude.get() == 1800000001) {
			return false;
		} else if (longitude.get() > 1800000001 || longitude.get() < -1800000000) {
			throw new IllegalArgumentException("Invalid longitude value!");
		} else
			return true;
	}

	@Override
	public double getLatitude() {
		return latitude.get() / TENTHS_OF_MICRODEGREE;
	}

	@Override
	public double getLongitude() {
		return longitude.get() / TENTHS_OF_MICRODEGREE;
	}

	@Override
	public String toString() {
		if (latitude != null && longitude != null)
			return "TwoDLocation [latitude=" + latitude.get() + ", longitude=" + longitude.get() + "]";
		else
			return "TwoDLocation [latitude=" + latitude + ", longitude=" + longitude + "]";
	}

}