package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class Time64WithStandardDeviation extends WaveElement {

	// ---- fields ----

	@Internal(order = 0)
	private Time64 time;

	@Internal(order = 1)
	private UInt8 logStdDev;

	// ---- fields ----

	// ---- constructors ----

	public Time64WithStandardDeviation() {
	}

	public Time64WithStandardDeviation(DataInputStream in) throws IOException {
		time = new Time64(in);
		logStdDev = new UInt8(in);
	}

	// ---- accept ----

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	// ---- getter ----

	public Time64 getTime() {
		return this.time;
	}

	public UInt8 getLogStdDev() {
		return this.logStdDev;
	}

	// ---- setter ----

	public void setTime(Time64 time) {
		this.time = time;
	}

	public void setLogStdDev(UInt8 logStdDev) {
		this.logStdDev = logStdDev;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		int written = 0;
		if (time == null || logStdDev == null)
			throw new IllegalArgumentException();
		written += time.writeData(out);
		written += logStdDev.writeData(out);
		return written;
	}
}