package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class Time64 extends WaveElement {
	
	// TODO Do same calculations as in Time32! (leap seconds, 2004-date, ...)

	// ---- fields ----

	@Internal(order = 0)
	private UInt64 time64;

	// ---- fields ----

	// ---- constructors ----

	public Time64() {
	}

	public Time64(DataInputStream in) throws IOException {
		time64 = new UInt64(in);
	}

	// ---- accept ----

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	// ---- getter ----

	public UInt64 getTime64() {
		return this.time64;
	}

	// ---- setter ----

	public void setTime64(UInt64 time64) {
		this.time64 = time64;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		if (time64 == null)
			throw new IllegalArgumentException();
		return time64.writeData(out);
	}

}